/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.code;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.code.FeaturestoreCode;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeaturestoreCodeFacade
extends AbstractFacade<FeaturestoreCode> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreCodeFacade() {
        super(FeaturestoreCode.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AbstractFacade.CollectionInfo<FeaturestoreCode> findByFeaturegroup(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Featuregroup featuregroup) {
        String queryStr = this.buildQuery("SELECT s from FeaturestoreCode s ", filters, sorts, "s.featureGroup = :featureGroup");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from FeaturestoreCode s ", filters, sorts, "s.featureGroup = :featureGroup");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreCode.class).setParameter("featureGroup", (Object)featuregroup);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeaturestoreCode.class).setParameter("featureGroup", (Object)featuregroup);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo<FeaturestoreCode> findByTrainingDataset(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, TrainingDataset trainingDataset) {
        String queryStr = this.buildQuery("SELECT s from FeaturestoreCode s ", filters, sorts, "s.trainingDataset = :trainingDataset");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from FeaturestoreCode s ", filters, sorts, "s.trainingDataset = :trainingDataset");
        TypedQuery query = this.em.createQuery(queryStr, FeaturestoreCode.class).setParameter("trainingDataset", (Object)trainingDataset);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeaturestoreCode.class).setParameter("trainingDataset", (Object)trainingDataset);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public Optional<FeaturestoreCode> findFeaturestoreCodeById(TrainingDataset trainingDataset, Integer id) {
        TypedQuery fssQuery = this.em.createNamedQuery("FeaturestoreCode.findByIdAndTrainingDataset", FeaturestoreCode.class).setParameter("id", (Object)id).setParameter("trainingDataset", (Object)trainingDataset);
        try {
            return Optional.of((FeaturestoreCode)fssQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeaturestoreCode> findFeaturestoreCodeById(Featuregroup featuregroup, Integer id) {
        TypedQuery fssQuery = this.em.createNamedQuery("FeaturestoreCode.findByIdAndFeatureGroup", FeaturestoreCode.class).setParameter("id", (Object)id).setParameter("featureGroup", (Object)featuregroup);
        try {
            return Optional.of((FeaturestoreCode)fssQuery.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            q.setParameter(filterBy.getField(), (Object)new Timestamp(Long.parseLong(filterBy.getParam())));
        }
    }

    public static enum Filters {
        COMMIT_TIME_GT("COMMIT_TIME_GT", "s.commitTime > :commitTime ", "commitTime", ""),
        COMMIT_TIME_LT("COMMIT_TIME_LT", "s.commitTime < :commitTime ", "commitTime", ""),
        COMMIT_TIME_EQ("COMMIT_TIME_EQ", "s.commitTime = :commitTime ", "commitTime", ""),
        APPLICATION_ID("APPLICATION_ID", "s.application_id = :application_id ", "application_id", "");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        COMMIT_TIME("COMMIT_TIME", "s.commitTime ", "DESC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

