/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.jupyter.CidAndPort;
import io.hops.hopsworks.common.jupyter.JupyterJWT;
import io.hops.hopsworks.common.jupyter.JupyterJWTDTO;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterJWTCache {
    private static final String MAP_NAME = "jupyterJWTMap";
    @Inject
    private HazelcastInstance hazelcastInstance;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private UserFacade userFacade;
    private final TreeSet<JupyterJWTDTO> jupyterJWTs = new TreeSet((t0, t1) -> {
        if (t0.equals(t1)) {
            return 0;
        }
        if (t0.getExpiration().isBefore(t1.getExpiration())) {
            return -1;
        }
        if (t0.getExpiration().isAfter(t1.getExpiration())) {
            return 1;
        }
        return 0;
    });
    private final HashMap<CidAndPort, JupyterJWT> pidAndPortToJWT = new HashMap();

    public void add(JupyterJWT jupyterJWT) {
        if (this.hazelcastInstance != null) {
            IMap pidAndPortToJWTMap = this.hazelcastInstance.getMap(MAP_NAME);
            pidAndPortToJWTMap.put((Object)jupyterJWT.pidAndPort, (Object)new JupyterJWTDTO(jupyterJWT));
        } else {
            this.jupyterJWTs.add(new JupyterJWTDTO(jupyterJWT));
            this.pidAndPortToJWT.put(jupyterJWT.pidAndPort, jupyterJWT);
        }
    }

    public Optional<JupyterJWT> get(CidAndPort pidAndPort) {
        if (this.hazelcastInstance != null) {
            IMap pidAndPortToJWTMap = this.hazelcastInstance.getMap(MAP_NAME);
            JupyterJWTDTO jupyterJWTDTO = (JupyterJWTDTO)pidAndPortToJWTMap.get((Object)pidAndPort);
            if (jupyterJWTDTO != null) {
                Project project = this.projectFacade.find(jupyterJWTDTO.getProjectId());
                Users user = (Users)this.userFacade.find(jupyterJWTDTO.getUserId());
                return Optional.of(new JupyterJWT(project, user, jupyterJWTDTO.getExpiration(), pidAndPort, jupyterJWTDTO.getToken(), Paths.get(jupyterJWTDTO.getTokenFile(), new String[0])));
            }
            return Optional.empty();
        }
        return Optional.ofNullable(this.pidAndPortToJWT.get(pidAndPort));
    }

    public void remove(CidAndPort pidAndPort) {
        if (this.hazelcastInstance != null) {
            IMap pidAndPortToJWTMap = this.hazelcastInstance.getMap(MAP_NAME);
            pidAndPortToJWTMap.remove((Object)pidAndPort);
        } else {
            JupyterJWT jupyterJWT = this.pidAndPortToJWT.remove(pidAndPort);
            this.jupyterJWTs.remove(new JupyterJWTDTO(jupyterJWT));
        }
    }

    public void replaceAll(Set<JupyterJWT> renewedJWTs) {
        if (this.hazelcastInstance != null) {
            IMap pidAndPortToJWTMap = this.hazelcastInstance.getMap(MAP_NAME);
            renewedJWTs.forEach(t -> {
                JupyterJWTDTO cfr_ignored_0 = (JupyterJWTDTO)pidAndPortToJWTMap.replace((Object)t.pidAndPort, (Object)new JupyterJWTDTO((JupyterJWT)t));
            });
        } else {
            renewedJWTs.forEach(t -> {
                JupyterJWT jupyterJWT = this.pidAndPortToJWT.remove(t.pidAndPort);
                this.jupyterJWTs.remove(new JupyterJWTDTO(jupyterJWT));
                this.jupyterJWTs.add(new JupyterJWTDTO((JupyterJWT)t));
                this.pidAndPortToJWT.put(t.pidAndPort, (JupyterJWT)t);
            });
        }
    }

    public int getSize() {
        if (this.hazelcastInstance != null) {
            IMap pidAndPortToJWTMap = this.hazelcastInstance.getMap(MAP_NAME);
            return pidAndPortToJWTMap.size();
        }
        return this.jupyterJWTs.size();
    }

    public Iterator<JupyterJWTDTO> getMaybeExpired() {
        if (this.hazelcastInstance != null) {
            IMap pidAndPortToJWTMap = this.hazelcastInstance.getMap(MAP_NAME);
            Predicate expirationPredicate = Predicates.lessEqual((String)"expiration", (Comparable)DateUtils.getNow());
            Collection jupyterJWTDTOS = pidAndPortToJWTMap.values(expirationPredicate);
            return jupyterJWTDTOS.iterator();
        }
        return this.jupyterJWTs.iterator();
    }
}

