/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.partition.Partition;
import fish.payara.cluster.Clustered;
import io.hops.hopsworks.common.upload.FlowInfo;
import io.hops.hopsworks.common.upload.UploadInfo;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@Clustered
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ResumableInfoProcessor
implements Serializable {
    private static final long serialVersionUID = 2660859257315228512L;
    private static final Logger LOGGER = Logger.getLogger(ResumableInfoProcessor.class.getName());

    public void put(FlowInfo flowInfo, HazelcastInstance hazelcastInstance, String mapName) {
        IMap uploadInfoMap = hazelcastInstance.getMap(mapName);
        uploadInfoMap.putIfAbsent((Object)flowInfo.hashCode(), (Object)new UploadInfo(flowInfo.getTotalSize()));
        LOGGER.log(Level.FINE, "Put chunk. id: {0}, {1}, uploadInfo: {2}", new Object[]{flowInfo.hashCode(), flowInfo, uploadInfoMap.get((Object)flowInfo.hashCode())});
    }

    public boolean addChunkAndCheckIfFinished(FlowInfo info, int rcn, long contentLength, HazelcastInstance hazelcastInstance, String mapName) {
        IMap uploadInfoMap = hazelcastInstance.getMap(mapName);
        UploadInfo uploadInfo = (UploadInfo)uploadInfoMap.get((Object)info.hashCode());
        if (uploadInfo == null) {
            LOGGER.log(Level.WARNING, "Failed to find upload info with id: {0}, rcn: {1}, {2}", new Object[]{info.hashCode(), rcn, info});
            return false;
        }
        boolean finished = uploadInfo.addChunkAndCheckIfFinished(rcn, contentLength);
        Partition partition = hazelcastInstance.getPartitionService().getPartition((Object)info.hashCode());
        LOGGER.log(Level.FINE, "Add chunk and check if finished. finished: {0}, id: {1}, rcn: {2}, uploadInfo: {3}, {4}, partitionId: {5}, partition owner: {6}", new Object[]{finished, info.hashCode(), rcn, uploadInfo, info, partition.getPartitionId(), partition.getOwner()});
        if (finished) {
            uploadInfoMap.remove((Object)info.hashCode());
        } else {
            uploadInfoMap.replace((Object)info.hashCode(), (Object)uploadInfo);
        }
        return finished;
    }

    @Lock(value=LockType.READ)
    public boolean uploaded(Integer identifier, Integer rcn, HazelcastInstance hazelcastInstance, String mapName) {
        IMap uploadInfo = hazelcastInstance.getMap(mapName);
        UploadInfo uInfo = (UploadInfo)uploadInfo.get((Object)identifier);
        return uInfo != null && uInfo.getUploadedChunks().contains(rcn);
    }
}

