/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.persistence.entity.project.team.ProjectRoleTypes;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;

public class OpenSearchUtils {
    public static String getKibanaTenantIndex(String project) {
        return ".kibana_" + project.hashCode() + "_" + OpenSearchUtils.getProjectNameWithNoSpecialCharacters(project);
    }

    public static String getAllKibanaTenantIndex(String project) {
        return OpenSearchUtils.getKibanaTenantIndex(project) + "*";
    }

    public static String getAllKibanaTenantIndex(Integer projectId) {
        return "onlinefs_" + projectId + "-*";
    }

    public static String getProjectNameWithNoSpecialCharacters(String project) {
        return project.toLowerCase().replaceAll("[^a-z0-9]+", "");
    }

    public static String getValidRole(String role) throws OpenSearchException {
        if (role == null) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.INVALID_OPENSEARCH_ROLE_USER, Level.SEVERE, "Invalid security role");
        }
        if (role.equals(ProjectRoleTypes.DATA_OWNER.getRole()) || role.equals(ProjectRoleTypes.DATA_SCIENTIST.getRole())) {
            return role.trim().toLowerCase().replace(" ", "_");
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.INVALID_OPENSEARCH_ROLE, Level.SEVERE, "Invalid security role : " + role);
    }
}

