/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.hdfs.xattrs.XAttrsController;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.dto.ProvCoreDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvDatasetDTO;
import io.hops.hopsworks.common.provenance.core.dto.ProvTypeDTO;
import io.hops.hopsworks.common.util.HopsworksJAXBContext;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.MetadataException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;

@Stateless(name="HopsFSProvenanceController")
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class HopsFSProvenanceController {
    private static final Logger LOGGER = Logger.getLogger(HopsFSProvenanceController.class.getName());
    @EJB
    private DistributedFsService dfs;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private Settings settings;
    @EJB
    private HopsworksJAXBContext converter;
    @EJB
    private XAttrsController xattrCtrl;
    @EJB
    private InodeController inodeController;

    private ProvCoreDTO getProvCoreXAttr(String path, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            byte[] provTypeB = this.xattrCtrl.getProvXAttr(udfso, path, "core");
            if (provTypeB == null) {
                return null;
            }
            return this.converter.unmarshal(new String(provTypeB), ProvCoreDTO.class);
        }
        catch (DatasetException | GenericException | MetadataException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - get xattr - prov core - error", "hopsfs - get xattr - prov core - error", e);
        }
    }

    private void setProvCoreXAttr(String path, ProvCoreDTO provCore, DistributedFileSystemOps udfso) throws ProvenanceException {
        try {
            String provType = this.converter.marshal(provCore);
            this.xattrCtrl.upsertProvXAttr(udfso, path, "core", provType.getBytes());
        }
        catch (DatasetException | GenericException | MetadataException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - set xattr - prov core - error", "hopsfs - set xattr - prov core - error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvTypeDTO getProjectProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        String projectPath = Utils.getProjectPath(project.getName());
        try {
            ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, udfso);
            ProvTypeDTO provTypeDTO = provCore == null ? null : provCore.getType();
            return provTypeDTO;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectProvType(Users user, Project project, ProvTypeDTO provType) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            this.updateProjectProvType(project, provType, udfso);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public void updateProjectProvType(Project project, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        String projectPath = Utils.getProjectPath(project.getName());
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        ProvCoreDTO provCore = this.getProvCoreXAttr(projectPath, dfso);
        if (provCore != null && newProvType.equals(provCore.getType())) {
            return;
        }
        provCore = new ProvCoreDTO(newProvType, null);
        this.setProvCoreXAttr(projectPath, provCore, dfso);
        provCore = new ProvCoreDTO(newProvType, projectInode.getId());
        for (Dataset dataset : project.getDatasetCollection()) {
            String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
            ProvCoreDTO datasetProvCore = this.getProvCoreXAttr(datasetPath, dfso);
            if (datasetProvCore != null && (datasetProvCore.getType().equals(Provenance.Type.DISABLED.dto) || datasetProvCore.getType().equals(newProvType))) continue;
            this.updateDatasetProvType(datasetPath, provCore, dfso);
        }
    }

    public void updateDatasetProvType(Dataset dataset, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        Inode projectInode = this.inodeController.getProjectRoot(dataset.getProject().getName());
        ProvCoreDTO newProvCore = new ProvCoreDTO(newProvType, projectInode.getId());
        String datasetPath = Utils.getFileSystemDatasetPath(dataset, this.settings);
        ProvCoreDTO currentProvCore = this.getProvCoreXAttr(datasetPath, dfso);
        if (currentProvCore != null && currentProvCore.getType().equals(newProvType)) {
            return;
        }
        this.updateDatasetProvType(datasetPath, newProvCore, dfso);
    }

    public void updateHiveDatasetProvCore(Project project, String hiveDBPath, ProvTypeDTO newProvType, DistributedFileSystemOps dfso) throws ProvenanceException {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        ProvCoreDTO newProvCore = new ProvCoreDTO(newProvType, projectInode.getId());
        ProvCoreDTO currentProvCore = this.getProvCoreXAttr(hiveDBPath, dfso);
        if (currentProvCore != null && currentProvCore.getType().equals(newProvType)) {
            return;
        }
        this.updateDatasetProvType(hiveDBPath, newProvCore, dfso);
    }

    private void updateDatasetProvType(String datasetPath, ProvCoreDTO provCore, DistributedFileSystemOps dfso) throws ProvenanceException {
        try {
            dfso.setMetaStatus(datasetPath, provCore.getType().getMetaStatus());
        }
        catch (IOException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.FS_ERROR, Level.WARNING, "hopsfs - dataset set meta status error", "hopsfs - dataset set meta status error", (Throwable)e);
        }
        this.setProvCoreXAttr(datasetPath, provCore, dfso);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvDatasetDTO> getDatasetsProvType(Users user, Project project) throws ProvenanceException {
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            ProvDatasetDTO dsState;
            Path datasetPath;
            ArrayList<ProvDatasetDTO> result = new ArrayList<ProvDatasetDTO>();
            Inode projectInode = this.inodeController.getProjectRoot(project.getName());
            for (Dataset dataset : project.getDatasetCollection()) {
                datasetPath = Utils.getDatasetPath(dataset, this.settings);
                ProvCoreDTO provCore = this.getProvCoreXAttr(datasetPath.toString(), udfso);
                if (provCore == null) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "malformed dataset - provenance", "no provenance core xattr");
                }
                Inode datasetInode = this.inodeController.getProjectDatasetInode(projectInode, datasetPath.toString(), dataset);
                dsState = new ProvDatasetDTO(dataset.getName(), datasetInode.getId(), provCore.getType());
                result.add(dsState);
            }
            for (Dataset dataset : project.getDatasetSharedWithCollection()) {
                datasetPath = Utils.getDatasetPath(dataset.getDataset(), this.settings);
                Inode datasetInode = this.inodeController.getInodeAtPath(datasetPath.toString());
                ProvCoreDTO provCore = this.getProvCoreXAttr(datasetPath.toString(), udfso);
                if (provCore == null) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.WARNING, "malformed dataset - provenance", "no provenance core xattr");
                }
                dsState = new ProvDatasetDTO(dataset.getDataset().getProject().getName() + "::" + dataset.getDataset().getName(), datasetInode.getId(), provCore.getType());
                result.add(dsState);
            }
            ArrayList<ProvDatasetDTO> arrayList = result;
            return arrayList;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public ProvTypeDTO getMetaStatus(Users user, Project project, Boolean searchable) throws ProvenanceException {
        if (searchable != null && searchable.booleanValue()) {
            return this.getProjectProvType(user, project);
        }
        return Provenance.Type.DISABLED.dto;
    }
}

