/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.arrowflight;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.arrowflight.ArrowFlightConnectorDTO;
import io.hops.hopsworks.common.arrowflight.ArrowFlightCredentialDTO;
import io.hops.hopsworks.common.arrowflight.ArrowFlightQueryDTO;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.project.AccessCredentialsDTO;
import io.hops.hopsworks.common.project.ProjectController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.bigquery.FeatureStoreBigqueryConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.snowflake.FeaturestoreSnowflakeConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.FlyingDuckTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.Location;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ArrowFlightController {
    @EJB
    protected StorageConnectorUtil storageConnectorUtil;
    @EJB
    private ProjectController projectController;
    @EJB
    protected ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    protected FeaturegroupController featuregroupController;
    private final ObjectMapper objectMapper = new ObjectMapper();

    private FlightClient initFlightClient(Project project, Users user) throws FeaturestoreException, InterruptedException {
        FlightClient flightClient = null;
        try {
            AccessCredentialsDTO accessCredentialsDTO = this.projectController.credentials(project, user);
            ByteArrayInputStream caChainInputStream = new ByteArrayInputStream(accessCredentialsDTO.getCaChain().getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream clientCertInputStream = new ByteArrayInputStream(accessCredentialsDTO.getClientCert().getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream clientKeyInputStream = new ByteArrayInputStream(accessCredentialsDTO.getClientKey().getBytes(StandardCharsets.UTF_8));
            Service flyingduckService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.FLYING_DUCK.getNameWithTag((ServiceTags)FlyingDuckTags.server));
            String flyingduckEndpoing = this.serviceDiscoveryController.constructServiceFQDN(HopsworksService.FLYING_DUCK.getName()) + ":" + flyingduckService.getPort();
            flightClient = FlightClient.builder().useTls().allocator((BufferAllocator)new RootAllocator()).location(new Location("grpc+tls://" + flyingduckEndpoing)).trustedCertificates((InputStream)caChainInputStream).clientCertificate((InputStream)clientCertInputStream, (InputStream)clientKeyInputStream).build();
            ArrowFlightCredentialDTO arrowFlightCredentials = new ArrowFlightCredentialDTO(accessCredentialsDTO);
            flightClient.doAction(new Action("register-client-certificates", this.objectMapper.writeValueAsString((Object)arrowFlightCredentials).getBytes()), new CallOption[0]).hasNext();
            return flightClient;
        }
        catch (Exception e) {
            if (flightClient != null) {
                flightClient.close();
            }
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_ARROW_FLIGHT_CONNECTION, Level.SEVERE, "project: " + project.getName(), e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public FeaturegroupPreview executeReadArrowFlightQuery(String query, Project project, Users user) throws FeaturestoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [46[UNCONDITIONALDOLOOP]], but top level block is 47[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getArrowFlightQuery(Featuregroup featuregroup, Project project, Users user, String tbl, int limit) throws FeaturestoreException {
        ArrowFlightQueryDTO queryDto = new ArrowFlightQueryDTO();
        String query = this.featuregroupController.getOfflineFeaturegroupQuery(featuregroup, project, user, tbl, limit);
        query = query.replace("`", "\"");
        queryDto.setQueryString(query);
        List<FeatureGroupFeatureDTO> features = this.featuregroupController.getFeatures(featuregroup, project, user);
        List featureNames = features.stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList());
        Map<String, List<String>> featureMap = Collections.singletonMap(tbl, featureNames);
        queryDto.setFeatures(featureMap);
        queryDto.setFilters(null);
        Map<String, ArrowFlightConnectorDTO> connectorMap = Collections.singletonMap(tbl, this.getArrowFlightConnectorDTO(featuregroup));
        queryDto.setConnectors(connectorMap);
        try {
            return this.objectMapper.writeValueAsString((Object)queryDto);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private ArrowFlightConnectorDTO getArrowFlightConnectorDTO(Featuregroup featuregroup) throws FeaturestoreException {
        ArrowFlightConnectorDTO connector = new ArrowFlightConnectorDTO();
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            OnDemandFeaturegroup onDemandFeaturegroup = featuregroup.getOnDemandFeaturegroup();
            FeaturestoreConnector featurestoreConnector = onDemandFeaturegroup.getFeaturestoreConnector();
            connector.setType(featurestoreConnector.getConnectorType().name());
            connector.setOptions(this.getConnectorOptions(featurestoreConnector));
            connector.setQuery(onDemandFeaturegroup.getQuery().replaceAll(";( )*$", ""));
            connector.setAlias(this.featuregroupController.getTblName(featuregroup));
            connector.setFilters(null);
        } else {
            connector.setType("hudi");
        }
        return connector;
    }

    private Map<String, String> getConnectorOptions(FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        switch (featurestoreConnector.getConnectorType()) {
            case SNOWFLAKE: {
                FeaturestoreSnowflakeConnector snowflakeConnector = featurestoreConnector.getSnowflakeConnector();
                optionMap.put("user", snowflakeConnector.getDatabaseUser());
                optionMap.put("account", snowflakeConnector.getUrl().replace("https://", "").replace(".snowflakecomputing.com", ""));
                optionMap.put("database", snowflakeConnector.getDatabaseName() + "/" + snowflakeConnector.getDatabaseSchema());
                if (snowflakeConnector.getPwdSecret() != null) {
                    optionMap.put("password", this.storageConnectorUtil.getSecret(snowflakeConnector.getPwdSecret(), String.class));
                } else {
                    optionMap.put("authenticator", "oauth");
                    optionMap.put("token", this.storageConnectorUtil.getSecret(snowflakeConnector.getTokenSecret(), String.class));
                }
                if (snowflakeConnector.getWarehouse() != null) {
                    optionMap.put("warehouse", snowflakeConnector.getWarehouse());
                }
                if (snowflakeConnector.getApplication() == null) break;
                optionMap.put("application", snowflakeConnector.getApplication());
                break;
            }
            case BIGQUERY: {
                FeatureStoreBigqueryConnector connector = featurestoreConnector.getBigqueryConnector();
                optionMap.put("key_path", connector.getKeyPath());
                optionMap.put("project_id", connector.getQueryProject());
                optionMap.put("dataset_id", connector.getDataset());
                optionMap.put("parent_project", connector.getParentProject());
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.SEVERE, "Arrow Flight doesn't support connector of type: " + featurestoreConnector.getConnectorType().name());
            }
        }
        return optionMap;
    }

    public void checkFeatureGroupSupportedByArrowFlight(Featuregroup featuregroup) throws FeaturestoreException {
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            OnDemandFeaturegroup onDemandFeaturegroup = featuregroup.getOnDemandFeaturegroup();
            FeaturestoreConnector featurestoreConnector = onDemandFeaturegroup.getFeaturestoreConnector();
            switch (featurestoreConnector.getConnectorType()) {
                case SNOWFLAKE: 
                case BIGQUERY: {
                    return;
                }
            }
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.SEVERE, "Arrow Flight doesn't support connector of type: " + featurestoreConnector.getConnectorType().name());
        }
    }
}

