/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.connectionChecker;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.connectionChecker.ConnectionCheckerDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.snowflake.FeaturestoreSnowflakeConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.snowflake.FeaturestoreSnowflakeConnectorDTO;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.opensearch.common.Strings;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ConnectionChecker {
    private static final Logger LOGGER = Logger.getLogger(ConnectionChecker.class.getName());
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private Settings settings;
    @EJB
    private FeaturestoreSnowflakeConnectorController snowflakeConnectorController;
    @EJB
    private ProjectUtils projectUtils;
    private Path STAGING_PATH;
    @EJB
    private HttpClient httpClient;

    @PostConstruct
    public void init() {
        this.STAGING_PATH = Paths.get(this.settings.getStagingDir(), "connectors");
    }

    public ConnectionCheckerDTO checkConnection(Users user, Project project, Featurestore featurestore, FeaturestoreStorageConnectorDTO storageConnectorDto) throws FeaturestoreException {
        ConnectionCheckerDTO connectionCheckerDTO;
        File jsonFile = null;
        switch (storageConnectorDto.getStorageConnectorType()) {
            case SNOWFLAKE: {
                this.snowflakeConnectorController.verifyConnectorDTO((FeaturestoreSnowflakeConnectorDTO)storageConnectorDto);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_TYPE, Level.FINE, "Storage connector type '" + storageConnectorDto.getStorageConnectorType() + "' is not yet supported");
            }
        }
        try {
            Files.createDirectories(this.STAGING_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_ERROR, Level.SEVERE, "Failed to create staging directory", e.getMessage(), (Throwable)e);
        }
        try {
            jsonFile = new File(this.buildInputFilePath(user, project, featurestore).toUri());
            LOGGER.log(Level.FINE, String.format("Creating input JSON at path %S", jsonFile.getAbsolutePath()));
            this.httpClient.getObjectMapper().writeValue(jsonFile, (Object)storageConnectorDto);
            ProcessResult result = this.execute(jsonFile.toPath());
            LOGGER.log(Level.FINE, String.format("Output response for connection test: %s%s", result.getStdout(), result.getStderr()));
            ConnectionCheckerDTO outputDto = new ConnectionCheckerDTO();
            outputDto.setConnectionOutput(String.format("%s%s", result.getStdout(), result.getStderr()));
            outputDto.setStatusCode(result.getExitCode());
            outputDto.setStorageConnectorDTO(storageConnectorDto);
            connectionCheckerDTO = outputDto;
        }
        catch (IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_ERROR, Level.SEVERE, "Failed to create JSON file from input request", e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.deleteStagedFile(jsonFile);
                throw throwable;
            }
        }
        this.deleteStagedFile(jsonFile);
        return connectionCheckerDTO;
    }

    private Path buildInputFilePath(Users user, Project project, Featurestore fs) {
        return Paths.get(this.STAGING_PATH.toString(), String.format("%s_%s_%s_%s.json", user.getUsername(), project.getId(), fs.getId(), System.currentTimeMillis()));
    }

    private void getContainerLogs(Path logFile) throws FeaturestoreException {
        if (Files.exists(logFile, new LinkOption[0])) {
            try {
                LOGGER.log(Level.FINE, String.format("Reading container logs from path %s", logFile.toAbsolutePath()));
                String logLines = String.join((CharSequence)"\n", Files.readAllLines(logFile));
                if (!Strings.isNullOrEmpty((String)logLines)) {
                    LOGGER.log(Level.INFO, logLines);
                }
            }
            catch (IOException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FILE_READ_ERROR, Level.SEVERE, String.format("Failure during reading container logs %s", logFile), "", (Throwable)e);
            }
            finally {
                this.deleteStagedFile(logFile.toFile());
            }
        }
    }

    private void deleteStagedFile(File file) throws FeaturestoreException {
        if (file != null) {
            try {
                FileUtils.delete((File)file);
                LOGGER.log(Level.FINE, "Deleted staged file: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FILE_DELETION_ERROR, Level.SEVERE, String.format("Failure during cleaning up staging file %s", file.getAbsolutePath()), "", (Throwable)e);
            }
        }
    }

    protected ProcessResult execute(Path jsonFile) throws FeaturestoreException {
        try {
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().setWaitTimeout(10L, TimeUnit.SECONDS).addCommand("/usr/bin/sudo").addCommand(Paths.get(this.settings.getSudoersDir(), this.settings.getTEST_CONNECTOR_LAUNCHER()).toString()).addCommand(jsonFile.toString()).addCommand(this.projectUtils.getFullDockerImageName(this.settings.getTestConnectorImage())).build();
            String containerLogFileName = FilenameUtils.getBaseName((String)jsonFile.toString()).concat(".log");
            LOGGER.log(Level.INFO, "Executing process to start docker container for testing connection");
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (processResult.getExitCode() != 0) {
                this.getContainerLogs(Paths.get(jsonFile.getParent().toString(), containerLogFileName));
            }
            LOGGER.log(Level.INFO, "Ended process of docker container for testing connection");
            return processResult;
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.DOCKER_FULLNAME_ERROR, Level.SEVERE, String.format("Full docker image not found for image %s", this.settings.getTestConnectorImage()), e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CONNECTION_CHECKER_LAUNCH_ERROR, Level.SEVERE, "Could not execute connection check", e.getMessage(), (Throwable)e);
        }
    }
}

