/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

import io.hops.hopsworks.common.serving.inference.InferencePort;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class InferenceEndpoint {
    private InferenceEndpointType type;
    private List<String> hosts;
    private List<InferencePort> ports;

    public InferenceEndpoint() {
    }

    public InferenceEndpoint(InferenceEndpointType type, List<String> hosts, List<InferencePort> ports) {
        this.type = type;
        this.hosts = hosts;
        this.ports = ports;
    }

    public InferenceEndpointType getType() {
        return this.type;
    }

    public void setType(InferenceEndpointType type) {
        this.type = type;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public String getAnyHost() {
        return this.hosts.stream().findAny().orElse(null);
    }

    public List<InferencePort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<InferencePort> ports) {
        this.ports = ports;
    }

    public InferencePort getPort(InferencePort.InferencePortName portName) {
        return this.ports.stream().filter(p -> p.getName() == portName).findAny().orElseThrow(NotFoundException::new);
    }

    public String getUrl(InferencePort.InferencePortName portName) {
        String protocol = portName == InferencePort.InferencePortName.HTTP || portName == InferencePort.InferencePortName.STATUS ? "http://" : "https://";
        String host = (String)this.getHosts().stream().findAny().orElseThrow(NotFoundException::new);
        Integer port = this.getPort(portName).getNumber();
        return protocol + host + ":" + port;
    }

    public static enum InferenceEndpointType {
        LOAD_BALANCER,
        KUBE_CLUSTER,
        NODE;

    }
}

