/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.metadata;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.metadata.FeatureStoreMetadata;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

public abstract class FeatureStoreMetadataFacade<M extends FeatureStoreMetadata>
extends AbstractFacade<M> {
    public static final String ID = "id";
    public static final String FEATURE_GROUP = "featureGroup";
    public static final String FEATURE_VIEW = "featureView";
    public static final String TRAINING_DATASET = "trainingDataset";
    @PersistenceContext(unitName="kthfsPU")
    protected EntityManager em;

    protected FeatureStoreMetadataFacade(Class<M> entityClass) {
        super(entityClass);
    }

    protected abstract String getTableName();

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void insertIfNotPresent(M metadata) {
        if (!this.em.contains(metadata) && metadata.getId() == null) {
            this.em.persist(metadata);
            this.em.flush();
        }
    }

    public void insertOrUpdate(M metadata) {
        if (metadata.getId() == null) {
            this.em.persist(metadata);
        } else {
            this.em.merge(metadata);
        }
        this.em.flush();
    }

    public Map<String, M> findAll(Featuregroup fg) {
        return this.findAll(FEATURE_GROUP, fg).stream().collect(Collectors.toMap(FeatureStoreMetadata::getName, t -> t));
    }

    public Map<String, M> findAll(FeatureView fv) {
        return this.findAll(FEATURE_VIEW, fv).stream().collect(Collectors.toMap(FeatureStoreMetadata::getName, t -> t));
    }

    public Map<String, M> findAll(TrainingDataset td) {
        return this.findAll(TRAINING_DATASET, td).stream().collect(Collectors.toMap(FeatureStoreMetadata::getName, t -> t));
    }

    public List<String> findAllAsNames(Featuregroup fg) {
        return this.findAll(FEATURE_GROUP, fg).stream().map(FeatureStoreMetadata::getName).collect(Collectors.toList());
    }

    public List<String> findAllAsNames(FeatureView fv) {
        return this.findAll(FEATURE_VIEW, fv).stream().map(FeatureStoreMetadata::getName).collect(Collectors.toList());
    }

    public List<String> findAllAsNames(TrainingDataset td) {
        return this.findAll(TRAINING_DATASET, td).stream().map(FeatureStoreMetadata::getName).collect(Collectors.toList());
    }

    private List<M> findAll(String artifactType, Object artifact) {
        String queryStr = "SELECT m FROM " + this.getTableName() + " m";
        queryStr = queryStr + " WHERE m." + artifactType + " = :" + artifactType;
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter(artifactType, artifact);
        return query.getResultList();
    }

    public int deleteAll(Featuregroup fg) {
        return this.deleteAll(FEATURE_GROUP, fg);
    }

    public int deleteAll(FeatureView fv) {
        return this.deleteAll(FEATURE_VIEW, fv);
    }

    public int deleteAll(TrainingDataset td) {
        return this.deleteAll(TRAINING_DATASET, td);
    }

    private int deleteAll(String artifactType, Object artifact) {
        String queryStr = "DELETE m FROM " + this.getTableName() + " m";
        queryStr = queryStr + " WHERE m." + artifactType + " = :" + artifactType;
        TypedQuery query = this.em.createQuery(queryStr, this.entityClass);
        query.setParameter(artifactType, artifact);
        return query.executeUpdate();
    }

    public Collector<M, ?, Map<String, M>> mapCollector() {
        return Collectors.toMap(FeatureStoreMetadata::getName, t -> t);
    }
}

