/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.xattr.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeatureStoreItem;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class FeaturegroupXAttr {

    public static enum FGType {
        ON_DEMAND,
        CACHED,
        STREAM;

    }

    public static class SimpleFeatureDTO {
        @JsonProperty(value="name")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String name;
        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String description;

        public SimpleFeatureDTO() {
        }

        public SimpleFeatureDTO(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            return "SimpleFeatureDTO{name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
        }
    }

    public static class SimplifiedDTO
    extends Base {
        @JsonProperty(value="name")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String name;
        @JsonProperty(value="version")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer version;
        @JsonProperty(value="fg_features")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private List<String> features = new LinkedList<String>();

        public SimplifiedDTO() {
        }

        public SimplifiedDTO(Integer featurestoreId, String name, Integer version) {
            super(featurestoreId);
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public List<String> getFeatures() {
            return this.features;
        }

        public void setFeatures(List<String> features) {
            this.features = features;
        }

        public void addFeature(String feature) {
            this.features.add(feature);
        }

        public void addFeatures(List<String> features) {
            this.features.addAll(features);
        }
    }

    public static class FullDTO
    extends Base
    implements FeatureStoreItem {
        @JsonProperty(value="description")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String description;
        @JsonProperty(value="create_date")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Long createDate;
        @JsonProperty(value="creator")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String creator;
        @JsonProperty(value="fgType")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private FGType fgType;
        @JsonProperty(value="fg_features")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private List<SimpleFeatureDTO> features = new LinkedList<SimpleFeatureDTO>();

        public FullDTO() {
        }

        public FullDTO(Integer featurestoreId, String description, Date createDate, String creator) {
            this(featurestoreId, description, createDate, creator, new LinkedList<SimpleFeatureDTO>());
        }

        public FullDTO(Integer featurestoreId, String description, Date createDate, String creator, List<SimpleFeatureDTO> features) {
            super(featurestoreId);
            this.features = features;
            this.description = description;
            this.createDate = createDate.getTime();
            this.creator = creator;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Long getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(Long createDate) {
            this.createDate = createDate;
        }

        @Override
        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public FGType getFgType() {
            return this.fgType;
        }

        public void setFgType(FGType fgType) {
            this.fgType = fgType;
        }

        public List<SimpleFeatureDTO> getFeatures() {
            return this.features;
        }

        public void setFeatures(List<SimpleFeatureDTO> features) {
            this.features = features;
        }

        public void addFeature(SimpleFeatureDTO feature) {
            this.features.add(feature);
        }

        public void addFeatures(List<SimpleFeatureDTO> features) {
            this.features.addAll(features);
        }

        @Override
        public String toString() {
            return super.toString() + "Extended{description='" + this.description + '\'' + ", createDate=" + this.createDate + ", creator='" + this.creator + '\'' + ", fgType='" + (Object)((Object)this.fgType) + '\'' + ", features=" + this.features + '}';
        }
    }

    public static abstract class Base {
        @JsonProperty(value="featurestore_id")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer featurestoreId;

        protected Base() {
        }

        protected Base(Integer featurestoreId) {
            this.featurestoreId = featurestoreId;
        }

        public Integer getFeaturestoreId() {
            return this.featurestoreId;
        }

        public void setFeaturestoreId(Integer featurestoreId) {
            this.featurestoreId = featurestoreId;
        }

        public String toString() {
            return "Base{featurestoreId=" + this.featurestoreId + '}';
        }
    }
}

