/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user.security.apiKey;

import io.hops.hopsworks.exceptions.ApiKeyException;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiKey;
import io.hops.hopsworks.persistence.entity.user.security.apiKey.ApiKeyScope;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Collection;
import java.util.logging.Level;
import javax.enterprise.inject.Instance;

public interface ApiKeyHandler {
    public void create(ApiKey var1) throws Exception;

    public void delete(ApiKey var1) throws Exception;

    public boolean match(Collection<ApiKeyScope> var1);

    public String getClassName();

    public static void runApiKeyCreateHandlers(Instance<ApiKeyHandler> apiKeyHandlers, ApiKey apiKey) throws ApiKeyException {
        ApiKeyHandler.runApiKeyCreateHandlers(apiKeyHandlers, apiKey, apiKey.getApiKeyScopeCollection());
    }

    public static void runApiKeyCreateHandlers(Instance<ApiKeyHandler> apiKeyHandlers, ApiKey apiKey, Collection<ApiKeyScope> scopes) throws ApiKeyException {
        for (ApiKeyHandler apiKeyHandler : apiKeyHandlers) {
            try {
                if (!apiKeyHandler.match(scopes)) continue;
                apiKeyHandler.create(apiKey);
            }
            catch (Exception e) {
                throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_HANDLER_CREATE_ERROR, Level.SEVERE, e.getMessage(), "apikey: " + apiKey.getName() + ", handler: " + apiKeyHandler.getClassName(), (Throwable)e);
            }
        }
    }

    public static void runApiKeyDeleteHandlers(Instance<ApiKeyHandler> apiKeyHandlers, ApiKey apiKey) throws ApiKeyException {
        ApiKeyHandler.runApiKeyDeleteHandlers(apiKeyHandlers, apiKey, apiKey.getApiKeyScopeCollection());
    }

    public static void runApiKeyDeleteHandlers(Instance<ApiKeyHandler> apiKeyHandlers, ApiKey apiKey, Collection<ApiKeyScope> scopes) throws ApiKeyException {
        for (ApiKeyHandler apiKeyHandler : apiKeyHandlers) {
            try {
                if (!apiKeyHandler.match(scopes)) continue;
                apiKeyHandler.delete(apiKey);
            }
            catch (Exception e) {
                throw new ApiKeyException(RESTCodes.ApiKeyErrorCode.KEY_HANDLER_DELETE_ERROR, Level.SEVERE, e.getMessage(), "apikey: " + apiKey.getName() + ", handler: " + apiKeyHandler.getClassName(), (Throwable)e);
            }
        }
    }
}

