/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AccessController {
    private static final Logger LOGGER = Logger.getLogger(AccessController.class.getName());
    private static final List<String> SERVICE_USERS = Arrays.asList("serving@hopsworks.se", "onlinefs@hopsworks.ai", "airflow@hopsworks.ai");

    public boolean hasAccess(Project userProject, Dataset targetDataset) {
        if (targetDataset.getProject().equals((Object)userProject)) {
            return true;
        }
        return targetDataset.getDatasetSharedWithCollection().stream().anyMatch(sds -> sds.getProject().equals((Object)userProject));
    }

    public boolean hasExtendedAccess(Users user, Project project) {
        boolean result = project.getProjectTeamCollection().stream().anyMatch(pt -> pt.getUser().equals((Object)user));
        if (result) {
            return true;
        }
        result = project.getDatasetSharedWithCollection().stream().filter(DatasetSharedWith::getAccepted).anyMatch(sds -> sds.getProject().getProjectTeamCollection().stream().anyMatch(t -> t.getUser().equals((Object)user)));
        if (result) {
            return true;
        }
        return project.getDatasetCollection().stream().flatMap(ds -> ds.getDatasetSharedWithCollection().stream()).filter(DatasetSharedWith::getAccepted).anyMatch(sds -> sds.getProject().getProjectTeamCollection().stream().anyMatch(t -> t.getUser().equals((Object)user)));
    }

    public Collection<ProjectTeam> getExtendedMembers(Dataset dataset) {
        List members = dataset.getProject().getProjectTeamCollection().stream().filter(pt -> !SERVICE_USERS.contains(pt.getUser().getEmail())).collect(Collectors.toCollection(ArrayList::new));
        List sharedDatasets = dataset.getDatasetSharedWithCollection().stream().filter(DatasetSharedWith::getAccepted).flatMap(sds -> sds.getProject().getProjectTeamCollection().stream()).filter(pt -> !SERVICE_USERS.contains(pt.getUser().getEmail())).collect(Collectors.toCollection(ArrayList::new));
        members.addAll(sharedDatasets);
        return members;
    }
}

