/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.commands;

import io.hops.hopsworks.common.commands.CommandException;
import io.hops.hopsworks.common.dao.commands.search.SearchFSCommandHistoryFacade;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.common.util.Settings;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Startup
@Singleton
@DependsOn(value={"Settings"})
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class CommandHistoryCleaner {
    private static final Logger LOGGER = Logger.getLogger(CommandHistoryCleaner.class.getName());
    @Resource
    private TimerService timerService;
    @EJB
    private Settings settings;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @EJB
    private SearchFSCommandHistoryFacade commandHistoryFacade;

    @PostConstruct
    public void init() {
        this.schedule();
    }

    private void schedule() {
        LOGGER.log(Level.INFO, "schedule");
        this.timerService.createSingleActionTimer(this.settings.commandSearchFSHistoryCleanPeriod().longValue(), new TimerConfig((Serializable)((Object)"command history cleaner"), false));
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void clean() {
        try {
            this.cleanInt();
        }
        catch (Exception t) {
            LOGGER.log(Level.INFO, "Command history cleaning failed with error:", t);
        }
        this.schedule();
    }

    private void cleanInt() throws CommandException {
        if (!this.payaraClusterManager.amIThePrimary()) {
            LOGGER.log(Level.INFO, "not primary");
            return;
        }
        if (this.settings.commandSearchFSHistoryEnabled()) {
            this.commandHistoryFacade.deleteOlderThan(this.settings.commandSearchFSHistoryWindow());
        }
    }
}

