/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.scheduler;

import io.hops.hopsworks.common.jobs.scheduler.JobScheduleV2Controller;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.ScheduleExpression;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Singleton
@Startup
public class JobScheduleV2Timer {
    private static final Logger LOGGER = Logger.getLogger(JobScheduleV2Timer.class.getName());
    @EJB
    private JobScheduleV2Controller jobScheduleController;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    private TimerService timerService;
    private Timer timer;

    @PostConstruct
    public void init() {
        ScheduleExpression schedule = new ScheduleExpression();
        schedule.hour("*");
        schedule.minute("*");
        this.timer = this.timerService.createCalendarTimer(schedule, new TimerConfig((Serializable)((Object)"Job scheduler timer"), false));
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void schedule() throws JobException, ProjectException, ServiceException, GenericException {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        LOGGER.fine("JobScheduleV2Timer schedule just triggered");
        this.jobScheduleController.executeWithCron();
    }
}

