/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.xattr.dto.FeaturestoreXAttrsConstants;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.opensearch.FeaturestoreDocType;
import io.hops.hopsworks.common.opensearch.KibanaClient;
import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.opensearch.OpenSearchUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.search.join.ScoreMode;
import org.json.JSONObject;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.FuzzyQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.PrefixQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OpenSearchController {
    @EJB
    private Settings settings;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private DatasetController datasetController;
    @EJB
    private InodeController inodeController;
    @EJB
    private KibanaClient kibanaClient;
    @EJB
    private OpenSearchClientController elasticClientCtrl;
    private static final Logger LOG = Logger.getLogger(OpenSearchController.class.getName());

    public SearchHit[] globalSearchHighLevel(String searchTerm) throws ServiceException, OpenSearchException {
        if (!this.elasticClientCtrl.mngIndexExists("projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        LOG.log(Level.FINE, "Found opensearch index, now executing the query.");
        SearchResponse response = this.executeSearchQuery(this.globalSearchQuery(searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            if (response.getHits().getHits().length > 0) {
                return response.getHits().getHits();
            }
            return new SearchHit[0];
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public SearchHit[] projectSearchHighLevel(Integer projectId, String searchTerm) throws ServiceException, OpenSearchException {
        if (!this.elasticClientCtrl.mngIndexExists("projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        SearchResponse response = this.executeSearchQuery(this.projectSearchQuery(projectId, searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            SearchHit[] hits = new SearchHit[]{};
            if (response.getHits().getHits().length > 0) {
                hits = response.getHits().getHits();
            }
            this.projectSearchInSharedDatasets(projectId, searchTerm, hits);
            return hits;
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public SearchHit[] datasetSearchHighLevel(Integer projectId, String datasetName, String searchTerm) throws ServiceException, OpenSearchException {
        Project project;
        if (!this.elasticClientCtrl.mngIndexExists("projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        String dsName = datasetName;
        if (datasetName.contains("::")) {
            String[] sharedDS = datasetName.split("::");
            dsName = sharedDS[1];
            project = this.projectFacade.findByName(sharedDS[0]);
        } else {
            project = this.projectFacade.find(projectId);
        }
        Dataset dataset = this.datasetController.getByProjectAndDsName(project, null, dsName);
        Path datasetPath = Utils.getDatasetPath(dataset, this.settings);
        Inode datasetInode = this.inodeController.getInodeAtPath(datasetPath.toString());
        SearchResponse response = this.executeSearchQuery(this.datasetSearchQuery(datasetInode.getId(), searchTerm.toLowerCase()));
        if (response.status().getStatus() == 200) {
            if (response.getHits().getHits().length > 0) {
                return response.getHits().getHits();
            }
            return new SearchHit[0];
        }
        throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.INFO, "Error while executing query, code: " + response.status().getStatus());
    }

    public SearchHit[] recentJupyterNotebookSearch(int count, int projectId) throws OpenSearchException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("xattr.");
        stringBuilder.append("jupyter_configuration.");
        stringBuilder.append("usage_time");
        String usage_time_path = stringBuilder.toString();
        FieldSortBuilder sortBuilder = ((FieldSortBuilder)SortBuilders.fieldSort((String)usage_time_path).order(SortOrder.DESC)).setNestedSort(new NestedSortBuilder("xattr")).unmappedType("long");
        SearchResponse response = this.executeJupyterSearchQuery(this.getRecentNotebooks(usage_time_path, projectId), count, (SortBuilder)sortBuilder);
        return response.getHits().getHits();
    }

    public Map<FeaturestoreDocType, SearchResponse> featurestoreSearch(FeaturestoreDocType docType, String searchTerm, int from, int size) throws OpenSearchException, ServiceException {
        if (!this.elasticClientCtrl.mngIndexExists("featurestore")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.SEVERE, "index: featurestore");
        }
        HashMap<FeaturestoreDocType, SearchResponse> result = new HashMap<FeaturestoreDocType, SearchResponse>();
        switch (docType) {
            case FEATUREGROUP: 
            case FEATUREVIEW: 
            case TRAININGDATASET: {
                QueryBuilder qb = this.baseFeatureStoreArtifactQueryB(docType, searchTerm);
                SearchResponse response = this.executeSearchQuery(qb, this.baseFeatureStoreArtifactHighlighter(), from, size);
                this.checkResponse(qb, response);
                result.put(docType, response);
                break;
            }
            case FEATURE: {
                QueryBuilder fQB = this.featureQueryB(searchTerm);
                SearchResponse response = this.executeSearchQuery(fQB, this.featureHighlighter(), 0, 10000);
                this.checkResponse(fQB, response);
                result.put(FeaturestoreDocType.FEATURE, response);
                break;
            }
            case ALL: {
                SearchQB[] qbs = new SearchQB[FeaturestoreDocType.values().length - 1];
                for (FeaturestoreDocType type : new FeaturestoreDocType[]{FeaturestoreDocType.FEATUREGROUP, FeaturestoreDocType.FEATUREVIEW, FeaturestoreDocType.TRAININGDATASET}) {
                    qbs[type.ordinal()] = new SearchQB(type, this.baseFeatureStoreArtifactQueryB(type, searchTerm), this.baseFeatureStoreArtifactHighlighter());
                }
                qbs[FeaturestoreDocType.FEATURE.ordinal()] = new SearchQB(FeaturestoreDocType.FEATURE, this.featureQueryB(searchTerm), this.featureHighlighter());
                MultiSearchResponse mResponse = this.executeSearchQuery(Arrays.asList(qbs), from, size);
                for (FeaturestoreDocType type : new FeaturestoreDocType[]{FeaturestoreDocType.FEATUREGROUP, FeaturestoreDocType.FEATUREVIEW, FeaturestoreDocType.TRAININGDATASET, FeaturestoreDocType.FEATURE}) {
                    SearchResponse searchResponse = mResponse.getResponses()[type.ordinal()].getResponse();
                    this.checkResponse(qbs[type.ordinal()].queryBuilder, searchResponse);
                    result.put(type, searchResponse);
                }
                break;
            }
        }
        return result;
    }

    public Map<FeaturestoreDocType, SearchResponse> featurestoreSearch(String searchTerm, Map<FeaturestoreDocType, Set<Integer>> docProjectIds, int from, int size) throws OpenSearchException, ServiceException, GenericException {
        SearchQB searchQB;
        if (!this.elasticClientCtrl.mngIndexExists("featurestore")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.OPENSEARCH_INDEX_NOT_FOUND, Level.SEVERE, "index: featurestore");
        }
        ArrayList<SearchQB> qbs = new ArrayList<SearchQB>();
        block4: for (FeaturestoreDocType docType : FeaturestoreDocType.values()) {
            if (!docProjectIds.containsKey((Object)docType)) continue;
            switch (docType) {
                case FEATUREGROUP: 
                case FEATUREVIEW: 
                case TRAININGDATASET: {
                    searchQB = new SearchQB(docType, this.addProjectToQuery(this.baseFeatureStoreArtifactQueryB(docType, searchTerm), docProjectIds.get((Object)docType)), this.baseFeatureStoreArtifactHighlighter());
                    qbs.add(searchQB);
                    continue block4;
                }
                case FEATURE: {
                    searchQB = new SearchQB(docType, this.addProjectToQuery(this.featureQueryB(searchTerm), docProjectIds.get((Object)docType)), this.featureHighlighter());
                    qbs.add(searchQB);
                    continue block4;
                }
                default: {
                    if (docType == FeaturestoreDocType.ALL) continue block4;
                    throw new GenericException(RESTCodes.GenericErrorCode.ILLEGAL_STATE, Level.SEVERE, "internal error - feature store search - unhandled" + (Object)((Object)docType));
                }
            }
        }
        MultiSearchResponse response = this.executeSearchQuery(qbs, from, size);
        if (response.getResponses().length != qbs.size()) {
            throw new GenericException(RESTCodes.GenericErrorCode.ILLEGAL_STATE, Level.SEVERE, "internal error - feature store search");
        }
        HashMap<FeaturestoreDocType, SearchResponse> result = new HashMap<FeaturestoreDocType, SearchResponse>();
        for (int i = 0; i < response.getResponses().length; ++i) {
            SearchResponse searchResponse = response.getResponses()[i].getResponse();
            searchQB = (SearchQB)qbs.get(i);
            this.checkResponse(searchQB.queryBuilder, searchResponse);
            result.put(searchQB.docType, searchResponse);
        }
        return result;
    }

    private QueryBuilder addProjectToQuery(QueryBuilder qb, Set<Integer> projectIds) {
        return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"project_id", projectIds)).must(qb);
    }

    private void checkResponse(QueryBuilder qb, SearchResponse response) throws OpenSearchException {
        if (response == null || response.status().getStatus() != 200) {
            LOG.log(Level.FINE, "error while executing query:{0} response is:{1}", new Object[]{qb, response == null ? null : Integer.valueOf(response.status().getStatus())});
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.OPENSEARCH_QUERY_ERROR, Level.WARNING, "Error while executing opensearch query");
        }
    }

    public void createIndexPattern(Project project, Users user, String pattern) throws ProjectException, OpenSearchException {
        JSONObject resp = this.kibanaClient.createIndexPattern(user, project, KibanaClient.KibanaType.IndexPattern, pattern);
        if (!(resp.has("updated_at") || resp.has("statusCode") && resp.get("statusCode").toString().equals("409"))) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_KIBANA_CREATE_INDEX_ERROR, Level.SEVERE, null, "project: " + project.getName() + ", resp: " + resp.toString(2), null);
        }
    }

    public void deleteProjectIndices(Project project) throws OpenSearchException {
        String[] indices;
        for (String index : indices = this.elasticClientCtrl.mngIndicesGetByRegex(new String[]{project.getName() + "_(((logs|serving|git)-\\d{4}.\\d{2}.\\d{2}))", "(((onlinefs)_" + project.getId() + "-\\d{4}.\\d{2}.\\d{2}))"})) {
            try {
                this.elasticClientCtrl.mngIndexDelete(index);
            }
            catch (OpenSearchException e) {
                LOG.log(Level.SEVERE, "Could not delete project index:{0}", index);
            }
        }
    }

    public void deleteProjectSavedObjects(Project project) throws OpenSearchException {
        if (!this.settings.isKibanaMultiTenancyEnabled().booleanValue()) {
            throw new UnsupportedOperationException("Only multitenant kibana setup supported.");
        }
        this.elasticClientCtrl.mngIndexDelete(OpenSearchUtils.getAllKibanaTenantIndex(project.getName().toLowerCase()));
        this.elasticClientCtrl.mngIndexDelete(OpenSearchUtils.getAllKibanaTenantIndex(project.getId()));
    }

    private SearchHit[] projectSearchInSharedDatasets(Integer projectId, String searchTerm, SearchHit[] elasticHits) throws OpenSearchException {
        Project project = this.projectFacade.find(projectId);
        Collection datasetSharedWithCollection = project.getDatasetSharedWithCollection();
        for (DatasetSharedWith ds : datasetSharedWithCollection) {
            Path datasetPath = Utils.getDatasetPath(ds.getDataset(), this.settings);
            Inode datasetInode = this.inodeController.getInodeAtPath(datasetPath.toString());
            long datasetId = datasetInode.getId();
            elasticHits = this.executeProjectSearchQuery(this.searchSpecificDataset(datasetId, searchTerm), elasticHits);
            elasticHits = this.executeProjectSearchQuery(this.datasetSearchQuery(datasetId, searchTerm), elasticHits);
        }
        return elasticHits;
    }

    private SearchHit[] executeProjectSearchQuery(QueryBuilder query, SearchHit[] elasticHits) throws OpenSearchException {
        SearchResponse response = this.executeSearchQuery(query);
        if (response.status().getStatus() == 200 && response.getHits().getHits().length > 0) {
            SearchHit[] hits = response.getHits().getHits();
            elasticHits = (SearchHit[])Stream.concat(Arrays.stream(elasticHits), Arrays.stream(hits)).toArray(SearchHit[]::new);
        }
        return elasticHits;
    }

    private SearchResponse executeSearchQuery(QueryBuilder query) throws OpenSearchException {
        return this.executeSearchQuery("projects", query);
    }

    private SearchResponse executeSearchQuery(String index, QueryBuilder query) throws OpenSearchException {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sb = new SearchSourceBuilder();
        sb.query(query);
        searchRequest.source(sb);
        return this.elasticClientCtrl.baseSearch(searchRequest);
    }

    private SearchResponse executeSearchQuery(QueryBuilder query, HighlightBuilder highlighter, int from, int size) throws OpenSearchException {
        SearchRequest searchRequest = new SearchRequest(new String[]{"featurestore"});
        SearchSourceBuilder sb = new SearchSourceBuilder().query(query).highlighter(highlighter).from(from).size(size);
        searchRequest.source(sb);
        return this.elasticClientCtrl.baseSearch(searchRequest);
    }

    private SearchResponse executeJupyterSearchQuery(QueryBuilder query, int size, SortBuilder sort) throws OpenSearchException {
        SearchRequest searchRequest = new SearchRequest(new String[]{"projects"});
        SearchSourceBuilder sb = new SearchSourceBuilder().query(query).size(size).sort(sort);
        searchRequest.source(sb);
        return this.elasticClientCtrl.baseSearch(searchRequest);
    }

    private MultiSearchResponse executeSearchQuery(Collection<SearchQB> searchQBs, int from, int size) throws OpenSearchException {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (SearchQB searchQB : searchQBs) {
            SearchRequest searchRequest = new SearchRequest(new String[]{"featurestore"});
            SearchSourceBuilder sb = new SearchSourceBuilder().query(searchQB.queryBuilder).highlighter(searchQB.highlightBuilder).from(from).size(size);
            searchRequest.source(sb);
            multiSearchRequest.add(searchRequest);
        }
        return this.elasticClientCtrl.multiSearch(multiSearchRequest);
    }

    private QueryBuilder searchSpecificDataset(Long datasetId, String searchTerm) {
        MatchQueryBuilder dataset = QueryBuilders.matchQuery((String)"_id", (Object)datasetId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        return QueryBuilders.boolQuery().must((QueryBuilder)dataset).must(nameDescQuery);
    }

    private QueryBuilder globalSearchQuery(String searchTerm) {
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndProjectsQuery = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "proj"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)onlyDatasetsAndProjectsQuery).must(nameDescQuery);
        return query;
    }

    private QueryBuilder projectSearchQuery(Integer projectId, String searchTerm) {
        TermQueryBuilder projectIdQuery = QueryBuilders.termQuery((String)"project_id", (Object)projectId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndInodes = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "inode"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)projectIdQuery).must((QueryBuilder)onlyDatasetsAndInodes).must(nameDescQuery);
        return query;
    }

    private QueryBuilder datasetSearchQuery(long datasetId, String searchTerm) {
        TermQueryBuilder datasetIdQuery = QueryBuilders.termQuery((String)"dataset_id", (long)datasetId);
        QueryBuilder query = this.getNameDescriptionMetadataQuery(searchTerm);
        TermQueryBuilder onlyInodes = QueryBuilders.termQuery((String)"doc_type", (String)"inode");
        BoolQueryBuilder cq = QueryBuilders.boolQuery().must((QueryBuilder)datasetIdQuery).must((QueryBuilder)onlyInodes).must(query);
        return cq;
    }

    private QueryBuilder baseFeatureStoreArtifactQueryB(FeaturestoreDocType type, String searchTerm) {
        BoolQueryBuilder termQuery = QueryBuilders.boolQuery().should(this.getNameQuery(searchTerm)).should(this.getDescriptionQuery(searchTerm)).should(this.getMetadataQuery(searchTerm));
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)type.toString().toLowerCase())).must((QueryBuilder)termQuery);
        return query;
    }

    private QueryBuilder featureQueryB(String searchTerm) {
        TermQueryBuilder featureQuery = QueryBuilders.termQuery((String)"doc_type", (String)FeaturestoreDocType.FEATUREGROUP.toString().toLowerCase());
        String featureName = FeaturestoreXAttrsConstants.getFeaturestoreOpenSearchKey("fg_features", "name");
        String description = FeaturestoreXAttrsConstants.getFeaturestoreOpenSearchKey("fg_features", "description");
        BoolQueryBuilder baseQuery = QueryBuilders.boolQuery().should(this.termFullTextQueryInt(featureName, searchTerm)).should(this.phraseFullTextQueryInt(description, searchTerm));
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"xattr", (QueryBuilder)baseQuery, (ScoreMode)ScoreMode.Avg);
        return QueryBuilders.boolQuery().must((QueryBuilder)featureQuery).must((QueryBuilder)nestedQuery);
    }

    private HighlightBuilder baseFeatureStoreArtifactHighlighter() {
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(new HighlightBuilder.Field("name"));
        hb.field(new HighlightBuilder.Field(FeaturestoreXAttrsConstants.getFeaturestoreOpenSearchKey("description")));
        hb.field(new HighlightBuilder.Field("xattr.*"));
        return hb;
    }

    private HighlightBuilder featureHighlighter() {
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(new HighlightBuilder.Field(FeaturestoreXAttrsConstants.getFeaturestoreOpenSearchKey("fg_features", "name")));
        hb.field(new HighlightBuilder.Field(FeaturestoreXAttrsConstants.getFeaturestoreOpenSearchKey("fg_features", "description")));
        return hb;
    }

    private QueryBuilder getNameDescriptionMetadataQuery(String searchTerm) {
        QueryBuilder nameQuery = this.getNameQuery(searchTerm);
        QueryBuilder descriptionQuery = this.getDescriptionQuery(searchTerm);
        QueryBuilder metadataQuery = this.getMetadataQuery(searchTerm);
        BoolQueryBuilder textCondition = QueryBuilders.boolQuery().should(nameQuery).should(descriptionQuery).should(metadataQuery);
        return textCondition;
    }

    private QueryBuilder getRecentNotebooks(String existsLocation, int projectId) {
        ExistsQueryBuilder existQuery = QueryBuilders.existsQuery((String)existsLocation);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)existQuery);
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"xattr", (QueryBuilder)boolQuery, (ScoreMode)ScoreMode.None);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"name", (String)"*ipynb");
        TermQueryBuilder termQuery = QueryBuilders.termQuery((String)"project_id", (int)projectId);
        BoolQueryBuilder nameQuery = QueryBuilders.boolQuery().must((QueryBuilder)nestedQuery).must((QueryBuilder)wildCardQuery).must((QueryBuilder)termQuery);
        return nameQuery;
    }

    private QueryBuilder getNameQuery(String searchTerm) {
        return this.termFullTextQueryInt("name", searchTerm);
    }

    private QueryBuilder termFullTextQueryInt(String key, String searchTerm) {
        PrefixQueryBuilder namePrefixMatch = QueryBuilders.prefixQuery((String)key, (String)searchTerm);
        MatchPhraseQueryBuilder namePhraseMatch = QueryBuilders.matchPhraseQuery((String)key, (Object)searchTerm);
        FuzzyQueryBuilder nameFuzzyQuery = QueryBuilders.fuzzyQuery((String)key, (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)key, (String)String.format("*%s*", searchTerm));
        return QueryBuilders.boolQuery().should((QueryBuilder)namePrefixMatch).should((QueryBuilder)namePhraseMatch).should((QueryBuilder)nameFuzzyQuery).should((QueryBuilder)wildCardQuery);
    }

    private QueryBuilder getDescriptionQuery(String searchTerm) {
        return this.phraseFullTextQueryInt("description", searchTerm);
    }

    private QueryBuilder phraseFullTextQueryInt(String key, String searchTerm) {
        PrefixQueryBuilder descriptionPrefixMatch = QueryBuilders.prefixQuery((String)key, (String)searchTerm);
        TermsQueryBuilder descriptionMatch = QueryBuilders.termsQuery((String)key, (String[])new String[]{searchTerm});
        MatchPhraseQueryBuilder descriptionPhraseMatch = QueryBuilders.matchPhraseQuery((String)key, (Object)searchTerm);
        FuzzyQueryBuilder descriptionFuzzyQuery = QueryBuilders.fuzzyQuery((String)key, (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)key, (String)String.format("*%s*", searchTerm));
        return QueryBuilders.boolQuery().should((QueryBuilder)descriptionPrefixMatch).should((QueryBuilder)descriptionMatch).should((QueryBuilder)descriptionPhraseMatch).should((QueryBuilder)descriptionFuzzyQuery).should((QueryBuilder)wildCardQuery);
    }

    private QueryBuilder getMetadataQuery(String searchTerm) {
        return this.getXAttrQuery("xattr.*", searchTerm);
    }

    private QueryBuilder getXAttrQuery(String key, String searchTerm) {
        QueryStringQueryBuilder metadataQuery = QueryBuilders.queryStringQuery((String)String.format("*%s*", searchTerm)).lenient(Boolean.TRUE).field(key);
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"xattr", (QueryBuilder)metadataQuery, (ScoreMode)ScoreMode.Avg);
        return nestedQuery;
    }

    private static class SearchQB {
        final FeaturestoreDocType docType;
        final QueryBuilder queryBuilder;
        final HighlightBuilder highlightBuilder;

        public SearchQB(FeaturestoreDocType docType, QueryBuilder queryBuilder, HighlightBuilder highlightBuilder) {
            this.docType = docType;
            this.queryBuilder = queryBuilder;
            this.highlightBuilder = highlightBuilder;
        }
    }
}

