/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import fish.payara.cluster.Clustered;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.security.MasterPasswordChangeResult;
import io.hops.hopsworks.common.security.MasterPasswordHandler;
import io.hops.hopsworks.common.security.MasterPasswordResetResult;
import io.hops.hopsworks.exceptions.EncryptionMasterPasswordException;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.AccessTimeout;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.enterprise.inject.Instance;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

@Clustered
@Singleton
public class CertificateMasterPwdMgm
implements Serializable {
    private static final long serialVersionUID = -2885415896363678090L;
    private static final Logger LOGGER = Logger.getLogger(CertificateMasterPwdMgm.class.getName());

    @Lock(value=LockType.READ)
    @AccessTimeout(value=3L, unit=TimeUnit.SECONDS)
    public String getMasterEncryptionPassword(File masterPasswordFile) throws IOException {
        return FileUtils.readFileToString((File)masterPasswordFile, (Charset)Charset.defaultCharset()).trim();
    }

    @Lock(value=LockType.READ)
    @AccessTimeout(value=3L, unit=TimeUnit.SECONDS)
    public void checkPassword(String providedPassword, String userRequestedEmail, File masterPasswordFile, UserFacade userFacade) throws IOException, EncryptionMasterPasswordException {
        String sha = DigestUtils.sha256Hex((String)providedPassword);
        if (!this.getMasterEncryptionPassword(masterPasswordFile).equals(sha)) {
            Users user = userFacade.findByEmail(userRequestedEmail);
            String logMsg = "*** Attempt to change master encryption password with wrong credentials";
            if (user != null) {
                LOGGER.log(Level.INFO, logMsg + " by user <" + user.getUsername() + ">");
            } else {
                LOGGER.log(Level.INFO, logMsg);
            }
            throw new EncryptionMasterPasswordException("Provided password is incorrect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Asynchronous
    @Lock(value=LockType.WRITE)
    @AccessTimeout(value=500L)
    public Future<MasterPasswordResetResult> resetMasterEncryptionPassword(String newMasterPasswd, File masterPasswordFile, Instance<MasterPasswordHandler> handlers, Map<Class, MasterPasswordChangeResult> handlersResult) {
        try {
            String newDigest = DigestUtils.sha256Hex((String)newMasterPasswd);
            this.callUpdateHandlers(newDigest, masterPasswordFile, handlers, handlersResult);
            this.updateMasterEncryptionPassword(newDigest, masterPasswordFile);
            StringBuilder successLog = this.gatherLogs(handlersResult);
            LOGGER.log(Level.INFO, "Master encryption password changed!");
            AsyncResult asyncResult = new AsyncResult((Object)new MasterPasswordResetResult(CertificatesMgmService.UPDATE_STATUS.OK, successLog.toString(), null));
            return asyncResult;
        }
        catch (EncryptionMasterPasswordException ex) {
            String errorMsg = "*** Master encryption password update failed!!! Rolling back...";
            LOGGER.log(Level.SEVERE, errorMsg, ex);
            this.callRollbackHandlers(handlers, handlersResult);
            AsyncResult asyncResult = new AsyncResult((Object)new MasterPasswordResetResult(CertificatesMgmService.UPDATE_STATUS.FAILED, null, errorMsg + "\n" + ex.getMessage()));
            return asyncResult;
        }
        catch (IOException ex) {
            String errorMsg = "*** Failed to write new encryption password to file: " + masterPasswordFile.getAbsolutePath() + ". Rolling back...";
            LOGGER.log(Level.SEVERE, errorMsg, ex);
            this.callRollbackHandlers(handlers, handlersResult);
            AsyncResult asyncResult = new AsyncResult((Object)new MasterPasswordResetResult(CertificatesMgmService.UPDATE_STATUS.FAILED, null, errorMsg + "\n" + ex.getMessage()));
            return asyncResult;
        }
        finally {
            handlersResult.clear();
        }
    }

    private void callUpdateHandlers(String newDigest, File masterPasswordFile, Instance<MasterPasswordHandler> handlers, Map<Class, MasterPasswordChangeResult> handlersResult) throws EncryptionMasterPasswordException, IOException {
        for (MasterPasswordHandler handler : handlers) {
            MasterPasswordChangeResult result = handler.perform(this.getMasterEncryptionPassword(masterPasswordFile), newDigest);
            handlersResult.put(handler.getClass(), result);
            if (result.getCause() == null) continue;
            throw result.getCause();
        }
    }

    private void callRollbackHandlers(Instance<MasterPasswordHandler> handlers, Map<Class, MasterPasswordChangeResult> handlersResult) {
        for (MasterPasswordHandler handler : handlers) {
            MasterPasswordChangeResult result = handlersResult.get(handler.getClass());
            if (result == null) continue;
            handler.rollback(result);
        }
    }

    private StringBuilder gatherLogs(Map<Class, MasterPasswordChangeResult> handlersResult) {
        StringBuilder successLog = new StringBuilder();
        for (MasterPasswordChangeResult result : handlersResult.values()) {
            if (result.getSuccessLog() == null) continue;
            successLog.append((CharSequence)result.getSuccessLog());
            successLog.append("\n\n");
        }
        return successLog;
    }

    private void updateMasterEncryptionPassword(String newPassword, File masterPasswordFile) throws IOException {
        FileUtils.writeStringToFile((File)masterPasswordFile, (String)newPassword, (Charset)Charset.defaultCharset());
    }
}

