/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import io.hops.hopsworks.common.upload.UploadUtils;
import java.util.HashSet;
import java.util.Objects;

public class FlowInfo {
    private int chunkNumber;
    private int chunkSize;
    private int currentChunkSize;
    private String filename;
    private String identifier;
    private String relativePath;
    private int totalChunks;
    private long totalSize;
    private String filePath;
    private long uploadedContentLength;
    private HashSet<Integer> uploadedChunks = new HashSet();

    public FlowInfo(int chunkNumber, int chunkSize, int currentChunkSize, String filename, String identifier, String relativePath, int totalChunks, long totalSize) {
        this.chunkNumber = chunkNumber;
        this.chunkSize = chunkSize;
        this.currentChunkSize = currentChunkSize;
        this.filename = filename;
        this.identifier = identifier;
        this.relativePath = relativePath;
        this.totalChunks = totalChunks;
        this.totalSize = totalSize;
    }

    public FlowInfo(String chunkNumber, String chunkSize, String currentChunkSize, String filename, String identifier, String relativePath, String totalChunks, String totalSize) {
        this.chunkNumber = UploadUtils.toInt(chunkNumber, -1);
        this.chunkSize = UploadUtils.toInt(chunkSize, -1);
        this.currentChunkSize = UploadUtils.toInt(currentChunkSize, -1);
        this.filename = filename;
        this.identifier = identifier;
        this.relativePath = relativePath;
        this.totalChunks = UploadUtils.toInt(totalChunks, -1);
        this.totalSize = UploadUtils.toLong(totalSize, -1L);
    }

    public boolean valid() {
        return this.chunkNumber >= 0 && this.totalSize >= 0L && !UploadUtils.isEmpty(this.identifier) && !UploadUtils.isEmpty(this.filename) && !UploadUtils.isEmpty(this.relativePath);
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public void setChunkNumber(int chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getCurrentChunkSize() {
        return this.currentChunkSize;
    }

    public void setCurrentChunkSize(int currentChunkSize) {
        this.currentChunkSize = currentChunkSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public void setTotalChunks(int totalChunks) {
        this.totalChunks = totalChunks;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getUploadedContentLength() {
        return this.uploadedContentLength;
    }

    public void setUploadedContentLength(long uploadedContentLength) {
        this.uploadedContentLength = uploadedContentLength;
    }

    public HashSet<Integer> getUploadedChunks() {
        return this.uploadedChunks;
    }

    public void setUploadedChunks(HashSet<Integer> uploadedChunks) {
        this.uploadedChunks = uploadedChunks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowInfo flowInfo = (FlowInfo)o;
        return Objects.equals(this.identifier, flowInfo.identifier) && Objects.equals(this.filePath, flowInfo.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.filePath);
    }

    public String toString() {
        return "FlowInfo{chunkNumber=" + this.chunkNumber + ", chunkSize=" + this.chunkSize + ", currentChunkSize=" + this.currentChunkSize + ", filename='" + this.filename + '\'' + ", identifier='" + this.identifier + '\'' + ", relativePath='" + this.relativePath + '\'' + ", totalChunks=" + this.totalChunks + ", totalSize=" + this.totalSize + '}';
    }
}

