/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.yarn;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.api.YarnClient;

public class YarnClientWrapper {
    private final Logger LOG = Logger.getLogger(YarnClientWrapper.class.getName());
    private final String projectName;
    private final String username;
    private final Configuration conf;
    private YarnClient yarnClient;

    public YarnClientWrapper(String projectName, String username, Configuration conf) {
        this.projectName = projectName;
        this.username = username;
        this.conf = conf;
    }

    public YarnClientWrapper get() {
        if (this.yarnClient == null) {
            this.yarnClient = YarnClient.createYarnClient();
            this.yarnClient.init(this.conf);
            this.yarnClient.start();
        }
        return this;
    }

    public YarnClient getYarnClient() {
        if (this.yarnClient == null) {
            throw new RuntimeException("YarnClient has not been initialized");
        }
        return this.yarnClient;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUsername() {
        return this.username;
    }

    public void close() {
        if (null != this.yarnClient) {
            try {
                this.yarnClient.close();
            }
            catch (IOException ex) {
                this.LOG.log(Level.WARNING, "Error while closing YarnClient", ex);
            }
        }
    }
}

