/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import io.hops.hopsworks.api.auth.UserUtilities;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GitOpException;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.exception.DuplicateSigningKeyException;
import io.hops.hopsworks.jwt.exception.SigningKeyNotFoundException;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FileUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class GitJWTManager {
    @EJB
    private JWTController jwtController;
    @EJB
    private Settings settings;
    @EJB
    private UserUtilities userUtilities;
    private final String TOKEN_FILE_NAME = "token.jwt";

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void materializeJWT(Users user, String tokenPath) throws GitOpException {
        LocalDateTime expirationDate = LocalDateTime.now().plus(this.settings.getGitJwtExpMs(), ChronoUnit.MILLIS);
        String token = this.createTokenForGitContainer(user, expirationDate);
        try {
            FileUtils.writeStringToFile((File)this.getTokenFullPath(tokenPath).toFile(), (String)token);
        }
        catch (IOException e) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.JWT_MATERIALIZATION_ERROR, Level.SEVERE, "Failed to materialize jwt", e.getMessage(), (Throwable)e);
        }
    }

    private String createTokenForGitContainer(Users user, LocalDateTime expirationDate) throws GitOpException {
        String[] userRoles = this.userUtilities.getUserRoles(user).toArray(new String[1]);
        return this.createTokenForGitContainer(user.getUsername(), userRoles, expirationDate);
    }

    private String createTokenForGitContainer(String username, String[] userRoles, LocalDateTime expirationDate) throws GitOpException {
        try {
            HashMap<String, Object> claims = new HashMap<String, Object>();
            claims.put("roles", userRoles);
            claims.put("renewable", false);
            return this.jwtController.createToken(this.settings.getJWTSigningKeyName(), false, this.settings.getJWTIssuer(), new String[]{"api", "git"}, DateUtils.localDateTime2Date(expirationDate), DateUtils.localDateTime2Date(DateUtils.getNow()), username, claims, SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg()));
        }
        catch (DuplicateSigningKeyException | SigningKeyNotFoundException | NoSuchAlgorithmException e) {
            throw new GitOpException((RESTCodes.RESTErrorCode)RESTCodes.GitOpErrorCode.JWT_NOT_CREATED, Level.SEVERE, "Failed to create jwt token for git", e.getMessage(), e);
        }
    }

    public Path getTokenFullPath(String tokenDir) {
        return Paths.get(tokenDir, "token.jwt");
    }
}

