/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.jobs.yarn.YarnMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class YarnLogUtil {
    private static final Logger LOGGER = Logger.getLogger(YarnLogUtil.class.getName());

    public void writeLog(DistributedFileSystemOps dfs, String dst, String message) {
        this.writeLog(dfs, dst, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog(DistributedFileSystemOps dfs, String dst, String message, Exception exception) {
        PrintStream writer = null;
        try {
            writer = new PrintStream((OutputStream)dfs.create(dst));
            if (exception != null && exception.getMessage() != null) {
                writer.print(message + "\n" + exception.getMessage());
            } else {
                writer.print(message);
            }
        }
        catch (IOException ex) {
            if (writer != null) {
                writer.print(YarnMonitor.class.getName() + ": Failed to write logs.\n" + ex.getMessage());
            }
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }
}

