/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dataset.acl;

import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.dataset.DatasetSharedWithFacade;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsGroupsFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.FsPermissions;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.dataset.DatasetSharedWith;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsGroups;
import io.hops.hopsworks.persistence.entity.hdfs.user.HdfsUsers;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectRoleTypes;
import io.hops.hopsworks.persistence.entity.project.team.ProjectTeam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.AccessTimeout;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

@Singleton
@AccessTimeout(value=10L, unit=TimeUnit.SECONDS)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PermissionsFixer {
    private static final Logger LOGGER = Logger.getLogger(PermissionsFixer.class.getName());
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private DatasetSharedWithFacade datasetSharedWithFacade;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private HdfsGroupsFacade hdfsGroupsFacade;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private InodeController inodeController;
    @EJB
    private Settings settings;
    @EJB
    private ProjectUtils projectUtils;

    @Asynchronous
    public void fixPermissions() {
        this.fixPermissions(0, 0L);
        LOGGER.log(Level.INFO, "Manual fix permissions triggered.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fixPermissions(int index, Long startTime) {
        List<Project> projectList = this.projectFacade.findAllOrderByCreated();
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            for (int i = index; i < projectList.size(); ++i) {
                Project project = projectList.get(i);
                this.fixPermissions(project, dfso);
                ++index;
                if (startTime <= 0L || System.currentTimeMillis() - startTime <= 300000L) continue;
                break;
            }
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
        if (index >= projectList.size()) {
            index = 0;
        }
        return index;
    }

    public void fixPermissions(Project project, DistributedFileSystemOps dfso) {
        if (this.isUnderRemoval(project)) {
            return;
        }
        try {
            this.fixProject(project, dfso);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to fix dataset permissions for project {0}. Error: {1}", new Object[]{project.getName(), e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixPermissions(Project project) {
        if (this.isUnderRemoval(project)) {
            return;
        }
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfsService.getDfsOps();
            this.fixProject(project, dfso);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to fix dataset permissions for project {0}. Error: {1}", new Object[]{project.getName(), e.getMessage()});
        }
        finally {
            this.dfsService.closeDfsClient(dfso);
        }
    }

    private void fixProject(Project project, DistributedFileSystemOps dfso) throws IOException {
        List<Dataset> datasetList = this.datasetFacade.findByProject(project);
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        for (Dataset dataset : datasetList) {
            this.fixDataset(projectInode, dataset, dfso);
        }
    }

    private void fixDataset(Inode projectInode, Dataset dataset, DistributedFileSystemOps dfso) throws IOException {
        String datasetGroup = this.hdfsUsersController.getHdfsGroupName(dataset.getProject(), dataset);
        String datasetAclGroup = this.hdfsUsersController.getHdfsAclGroupName(dataset.getProject(), dataset);
        HdfsGroups hdfsDatasetGroup = this.getOrCreateGroup(datasetGroup, dfso);
        HdfsGroups hdfsDatasetAclGroup = this.getOrCreateGroup(datasetAclGroup, dfso);
        this.fixPermission(projectInode, dataset, hdfsDatasetGroup, hdfsDatasetAclGroup, dfso);
    }

    private HdfsGroups getOrCreateGroup(String group, DistributedFileSystemOps dfso) throws IOException {
        HdfsGroups hdfsGroup = this.hdfsGroupsFacade.findByName(group);
        if (hdfsGroup == null) {
            dfso.addGroup(group);
            hdfsGroup = this.hdfsGroupsFacade.findByName(group);
            LOGGER.log(Level.WARNING, "Found and fixed a missing group: group={0}", group);
        }
        return hdfsGroup;
    }

    private void fixPermission(Inode projectInode, Dataset dataset, HdfsGroups hdfsDatasetGroup, HdfsGroups hdfsDatasetAclGroup, DistributedFileSystemOps dfso) throws IOException {
        if (hdfsDatasetGroup == null || hdfsDatasetAclGroup == null) {
            LOGGER.log(Level.WARNING, "Failed to get groups: hdfsDatasetGroup or hdfsDatasetAclGroup");
            return;
        }
        if (dataset.isPublicDs() && !DatasetAccessPermission.READ_ONLY.equals((Object)dataset.getPermission())) {
            dataset.setPermission(DatasetAccessPermission.READ_ONLY);
            this.datasetFacade.merge(dataset);
        }
        Inode datasetInode = this.inodeController.getProjectDatasetInode(projectInode, Utils.getDatasetPath(dataset, this.settings).toString(), dataset);
        this.testFsPermission(dataset, datasetInode, dfso);
        this.testAndFixPermissionForAllMembers(dataset.getProject(), dfso, hdfsDatasetGroup, hdfsDatasetAclGroup, datasetInode.getHdfsUser(), dataset.getPermission());
        ArrayList<ProjectTeam> datasetTeamCollection = new ArrayList<ProjectTeam>(this.projectUtils.getProjectTeamCollection(dataset.getProject()));
        for (DatasetSharedWith datasetSharedWith : dataset.getDatasetSharedWithCollection()) {
            if (dataset.isPublicDs() && !DatasetAccessPermission.READ_ONLY.equals((Object)datasetSharedWith.getPermission())) {
                datasetSharedWith.setPermission(DatasetAccessPermission.READ_ONLY);
                this.datasetSharedWithFacade.update(datasetSharedWith);
            }
            if (!datasetSharedWith.getAccepted()) continue;
            this.testAndFixPermissionForAllMembers(datasetSharedWith.getProject(), dfso, hdfsDatasetGroup, hdfsDatasetAclGroup, null, datasetSharedWith.getPermission());
            datasetTeamCollection.addAll(this.projectUtils.getProjectTeamCollection(datasetSharedWith.getProject()));
        }
        this.testAndRemoveUsersFromGroup(datasetTeamCollection, hdfsDatasetGroup, hdfsDatasetAclGroup, datasetInode.getHdfsUser(), dfso);
    }

    private void testFsPermission(Dataset dataset, Inode datasetInode, DistributedFileSystemOps dfso) throws IOException {
        FsPermission fsPermission = FsPermission.createImmutable((short)datasetInode.getPermission());
        FsPermission fsPermissionReadOnly = FsPermission.createImmutable((short)360);
        FsPermission fsPermissionReadOnlyT = FsPermission.createImmutable((short)872);
        FsPermission fsPermissionDefault = FsPermissions.rwxrwx___;
        FsPermission fsPermissionDefaultT = FsPermissions.rwxrwx___T;
        Path path = new Path(this.inodeController.getPath(datasetInode));
        if (dataset.isPublicDs() && !fsPermissionReadOnly.equals((Object)fsPermission) && !fsPermissionReadOnlyT.equals((Object)fsPermission)) {
            this.hdfsUsersController.makeImmutable(path, dfso);
            LOGGER.log(Level.WARNING, "Found and fixed a public dataset with wrong permission. id={0}, permission={1}", new Object[]{dataset.getId(), fsPermission});
        }
        if (!(dataset.isPublicDs() || fsPermissionDefault.equals((Object)fsPermission) || fsPermissionDefaultT.equals((Object)fsPermission))) {
            this.hdfsUsersController.undoImmutable(path, dfso);
            LOGGER.log(Level.WARNING, "Found and fixed a dataset with wrong permission. id={0}, permission={1}", new Object[]{dataset.getId(), fsPermission});
        }
    }

    private void testAndFixPermissionForAllMembers(Project project, DistributedFileSystemOps dfso, HdfsGroups hdfsDatasetGroup, HdfsGroups hdfsDatasetAclGroup, HdfsUsers owner, DatasetAccessPermission permission) throws IOException {
        for (ProjectTeam projectTeam : this.projectUtils.getProjectTeamCollection(project)) {
            this.testAndFixPermission(projectTeam, dfso, hdfsDatasetGroup, hdfsDatasetAclGroup, owner, permission);
        }
    }

    private void testAndRemoveUsersFromGroup(Collection<ProjectTeam> projectTeamCollection, HdfsGroups hdfsDatasetGroup, HdfsGroups hdfsDatasetAclGroup, HdfsUsers owner, DistributedFileSystemOps dfso) throws IOException {
        for (HdfsUsers hdfsUsers : hdfsDatasetGroup.getHdfsUsersCollection()) {
            this.testAndRemoveMember(projectTeamCollection, hdfsDatasetGroup, hdfsUsers, owner, dfso);
        }
        for (HdfsUsers hdfsUsers : hdfsDatasetAclGroup.getHdfsUsersCollection()) {
            this.testAndRemoveMember(projectTeamCollection, hdfsDatasetAclGroup, hdfsUsers, owner, dfso);
        }
    }

    private void testAndRemoveMember(Collection<ProjectTeam> projectTeamCollection, HdfsGroups group, HdfsUsers hdfsUser, HdfsUsers owner, DistributedFileSystemOps dfso) throws IOException {
        if (hdfsUser == null || hdfsUser.equals((Object)owner)) {
            return;
        }
        boolean found = false;
        for (ProjectTeam projectTeam : projectTeamCollection) {
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(projectTeam.getProject(), projectTeam.getUser());
            if (!hdfsUser.getName().equals(hdfsUsername)) continue;
            found = true;
        }
        if (!found) {
            this.removeFromGroup(hdfsUser, group, dfso);
        }
    }

    private void testAndFixPermission(ProjectTeam projectTeam, DistributedFileSystemOps dfso, HdfsGroups hdfsDatasetGroup, HdfsGroups hdfsDatasetAclGroup, HdfsUsers owner, DatasetAccessPermission permission) throws IOException {
        if (projectTeam.getUser().getUsername().equals("srvmanager") || projectTeam.getUser().getUsername().equals("onlinefs")) {
            return;
        }
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(projectTeam.getProject(), projectTeam.getUser());
        HdfsUsers hdfsUser = this.hdfsUsersController.getOrCreateUser(hdfsUsername, dfso);
        if (owner != null && owner.equals((Object)hdfsUser)) {
            return;
        }
        switch (permission) {
            case EDITABLE: {
                if (!hdfsDatasetGroup.hasUser(hdfsUser)) {
                    this.addToGroup(hdfsUser, hdfsDatasetGroup, dfso);
                }
                if (!hdfsDatasetAclGroup.hasUser(hdfsUser)) break;
                this.removeFromGroup(hdfsUser, hdfsDatasetAclGroup, dfso);
                break;
            }
            case READ_ONLY: {
                if (hdfsDatasetGroup.hasUser(hdfsUser)) {
                    this.removeFromGroup(hdfsUser, hdfsDatasetGroup, dfso);
                }
                if (hdfsDatasetAclGroup.hasUser(hdfsUser)) break;
                this.addToGroup(hdfsUser, hdfsDatasetAclGroup, dfso);
                break;
            }
            case EDITABLE_BY_OWNERS: {
                if ("Data owner".equals(projectTeam.getTeamRole())) {
                    if (!hdfsDatasetGroup.hasUser(hdfsUser)) {
                        this.addToGroup(hdfsUser, hdfsDatasetGroup, dfso);
                    }
                    if (!hdfsDatasetAclGroup.hasUser(hdfsUser)) break;
                    this.removeFromGroup(hdfsUser, hdfsDatasetAclGroup, dfso);
                    break;
                }
                if (hdfsDatasetGroup.hasUser(hdfsUser)) {
                    this.removeFromGroup(hdfsUser, hdfsDatasetGroup, dfso);
                }
                if (hdfsDatasetAclGroup.hasUser(hdfsUser)) break;
                this.addToGroup(hdfsUser, hdfsDatasetAclGroup, dfso);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Found a dataset with an unknown permission: group={0}, project={1}", new Object[]{hdfsDatasetGroup, projectTeam.getProject().getName()});
            }
        }
    }

    private void addToGroup(HdfsUsers hdfsUser, HdfsGroups group, DistributedFileSystemOps dfso) throws IOException {
        this.hdfsUsersController.addToGroup(hdfsUser.getName(), group.getName(), dfso);
        LOGGER.log(Level.WARNING, "Found and fixed a user not added to a dataset group. user={0}, group={1}", new Object[]{hdfsUser.getName(), group.getName()});
    }

    private void removeFromGroup(HdfsUsers hdfsUser, HdfsGroups group, DistributedFileSystemOps dfso) throws IOException {
        this.hdfsUsersController.removeFromGroup(hdfsUser, group, dfso);
        LOGGER.log(Level.WARNING, "Found and fixed a user in the wrong dataset group. user={0}, group={1}", new Object[]{hdfsUser.getName(), group.getName()});
    }

    private boolean isUnderRemoval(Project project) {
        for (ProjectTeam member : project.getProjectTeamCollection()) {
            if (!ProjectRoleTypes.UNDER_REMOVAL.getRole().equals(member.getTeamRole())) continue;
            return true;
        }
        return false;
    }
}

