/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.utils;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.api.ResourceRequest;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeaturegroupPreview;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.NamenodeTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.core.UriBuilder;
import org.javatuples.Pair;

@Stateless
public class FeaturestoreUtils {
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    protected ServiceDiscoveryController serviceDiscoveryController;

    private void throwForbiddenOperation(Featurestore featureStore, String userRole, Project project, Object object, ActionMessage actionMessage) throws FeaturestoreException {
        ArrayList<String> messageContent = new ArrayList<String>();
        if (project != null) {
            messageContent.add(String.format("project: %s", project.getName()));
        }
        if (featureStore != null) {
            messageContent.add(String.format("featurestoreId: %s", featureStore.getId()));
        }
        if (userRole != null) {
            messageContent.add(String.format("userRole: %s", userRole));
        }
        if (object != null) {
            if (object instanceof Featuregroup) {
                Featuregroup featuregroup = (Featuregroup)object;
                messageContent.add(String.format("feature group: %s, version: %s", featuregroup.getName(), featuregroup.getVersion()));
            } else if (object instanceof TrainingDataset) {
                TrainingDataset trainingDataset = (TrainingDataset)object;
                messageContent.add(String.format("training dataset: %s, version: %s", trainingDataset.getName(), trainingDataset.getName()));
            } else if (object instanceof FeatureView) {
                FeatureView featureView = (FeatureView)object;
                messageContent.add(String.format("feature view: %s, version: %s", featureView.getName(), featureView.getVersion()));
            } else if (object instanceof FeaturestoreConnector) {
                FeaturestoreConnector featurestoreConnector = (FeaturestoreConnector)object;
                messageContent.add(String.format("storage connector: %s", featurestoreConnector.getName()));
            } else if (object instanceof Jobs) {
                Jobs job = (Jobs)object;
                messageContent.add(String.format("jobs: %s", job.getName()));
            }
        }
        if (actionMessage != null) {
            messageContent.add(String.format("actionMessage: Forbidden to %s", actionMessage.getMessage()));
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FORBIDDEN_FEATURESTORE_OPERATION, Level.FINE, String.join((CharSequence)", ", messageContent));
    }

    public void verifyUserProjectEqualsFsProject(Users user, Project project, Featurestore featureStore, ActionMessage actionMessage) throws FeaturestoreException {
        if (!featureStore.getProject().equals((Object)project)) {
            String userRole = this.projectTeamFacade.findCurrentRole(project, user);
            this.throwForbiddenOperation(featureStore, userRole, project, null, actionMessage);
        }
    }

    public void verifyUserProjectEqualsFsProjectAndDataOwner(Users user, Project project, Featurestore featureStore, ActionMessage actionMessage) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!featureStore.getProject().equals((Object)project) || !"Data owner".equalsIgnoreCase(userRole)) {
            this.throwForbiddenOperation(featureStore, userRole, project, null, actionMessage);
        }
    }

    public void verifyTrainingDatasetDataOwnerOrSelf(Users user, Project project, TrainingDataset trainingDataset, ActionMessage actionMessage) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!trainingDataset.getFeaturestore().getProject().equals((Object)project) || !"Data owner".equalsIgnoreCase(userRole) && !trainingDataset.getCreator().equals((Object)user)) {
            this.throwForbiddenOperation(trainingDataset.getFeaturestore(), userRole, project, trainingDataset, actionMessage);
        }
    }

    public void verifyFeatureViewDataOwnerOrSelf(Users user, Project project, FeatureView featureView, ActionMessage actionMessage) throws FeaturestoreException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        if (!featureView.getFeaturestore().getProject().equals((Object)project) || !"Data owner".equalsIgnoreCase(userRole) && !featureView.getCreator().equals((Object)user)) {
            this.throwForbiddenOperation(featureView.getFeaturestore(), userRole, project, featureView, actionMessage);
        }
    }

    public String resolveLocation(String location) throws ServiceException {
        try {
            String namenodeAddress = this.serviceDiscoveryController.constructServiceAddressWithPort(HopsworksService.NAMENODE.getNameWithTag((ServiceTags)NamenodeTags.rpc));
            return "hopsfs://" + namenodeAddress + location;
        }
        catch (ServiceDiscoveryException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE, ex.getMessage(), ex.getMessage(), (Throwable)ex);
        }
    }

    public String prependNameNode(String hdfsPath) throws ServiceDiscoveryException {
        Service namenode = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.NAMENODE.getNameWithTag((ServiceTags)NamenodeTags.rpc));
        return "hopsfs://" + namenode.getName() + ":" + namenode.getPort() + hdfsPath;
    }

    public UriBuilder featureGroupByIdURI(UriBuilder uriBuilder, Project accessProject, Featuregroup featureGroup) {
        return uriBuilder.path(ResourceRequest.Name.PROJECT.toString().toLowerCase()).path(Integer.toString(accessProject.getId())).path(ResourceRequest.Name.FEATURESTORES.toString().toLowerCase()).path(Integer.toString(featureGroup.getFeaturestore().getId())).path(ResourceRequest.Name.FEATUREGROUPS.toString().toLowerCase()).path(Integer.toString(featureGroup.getId()));
    }

    public UriBuilder featureViewURI(UriBuilder uriBuilder, Project accessProject, FeatureView featureView) {
        return uriBuilder.path(ResourceRequest.Name.PROJECT.toString().toLowerCase()).path(Integer.toString(accessProject.getId())).path(ResourceRequest.Name.FEATURESTORES.toString().toLowerCase()).path(Integer.toString(featureView.getFeaturestore().getId())).path(ResourceRequest.Name.FEATUREVIEW.toString().toLowerCase()).path(featureView.getName()).path(ResourceRequest.Name.VERSION.toString().toLowerCase()).path(Integer.toString(featureView.getVersion()));
    }

    public UriBuilder trainingDatasetURI(UriBuilder uriBuilder, Project accessProject, TrainingDataset trainingDataset) {
        return this.featureViewURI(uriBuilder, accessProject, trainingDataset.getFeatureView()).path(ResourceRequest.Name.TRAININGDATASETS.toString().toLowerCase()).path(ResourceRequest.Name.VERSION.toString().toLowerCase()).path(Integer.toString(trainingDataset.getVersion()));
    }

    public FeaturegroupPreview parseResultset(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        FeaturegroupPreview featuregroupPreview = new FeaturegroupPreview();
        while (rs.next()) {
            FeaturegroupPreview.Row row = new FeaturegroupPreview.Row();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                Object columnValue = rs.getObject(i);
                row.addValue((Pair<String, String>)new Pair((Object)this.parseColumnLabel(rsmd.getColumnLabel(i)), (Object)(columnValue == null ? null : columnValue.toString())));
            }
            featuregroupPreview.addRow(row);
        }
        return featuregroupPreview;
    }

    private String parseColumnLabel(String columnLabel) {
        if (columnLabel.contains(".")) {
            return columnLabel.split("\\.")[1];
        }
        return columnLabel;
    }

    public static enum ActionMessage {
        CREATE_FEATURE_GROUP("create feature group"),
        CLEAR_FEATURE_GROUP("clear feature group"),
        UPDATE_FEATURE_GROUP_METADATA("update feature group metadata"),
        ENABLE_FEATURE_GROUP_ONLINE("enable online feature group"),
        DISABLE_FEATURE_GROUP_ONLINE("disable online feature group"),
        UPDATE_FEATURE_GROUP_STATS_CONFIG("update feature group stats config"),
        DELETE_FEATURE_GROUP("delete feature group"),
        CREATE_FEATURE_VIEW("create feature view"),
        DELETE_FEATURE_VIEW("delete feature view"),
        UPDATE_FEATURE_VIEW("update feature view"),
        CREATE_TRAINING_DATASET("create training dataset"),
        DELETE_TRAINING_DATASET("delete training dataset"),
        DELETE_TRAINING_DATASET_DATA_ONLY("delete training dataset data only"),
        UPDATE_TRAINING_DATASET_METADATA("update training dataset metadata"),
        UPDATE_TRAINING_DATASET_STATS_CONFIG("update training dataset stats config"),
        SETUP_TRAINING_DATASET_JOB("setup training dataset job"),
        CREATE_STORAGE_CONNECTOR("create storage connector"),
        UPDATE_STORAGE_CONNECTOR("update storage connector"),
        DELETE_STORAGE_CONNECTOR("delete storage connector");

        private String message;

        private ActionMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

