/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.pythonresources;

import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class DockerCgroupsMonitor {
    private static final Logger LOGGER = Logger.getLogger(DockerCgroupsMonitor.class.getName());
    private static Long memoryHardLimit = 0x7FFFFFFFFFFFF000L;
    private static Long memorySoftLimit = 0x7FFFFFFFFFFFF000L;
    private static Double cpuQuota = 100.0;
    private static Integer cpuPeriod = 100000;
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @Resource
    private TimerService timerService;

    @PostConstruct
    public void init() {
        String rawInterval = this.settings.getDockerCgroupIntervalMonitor();
        Long intervalValue = this.settings.getConfTimeValue(rawInterval);
        TimeUnit intervalTimeunit = this.settings.getConfTimeTimeUnit(rawInterval);
        intervalValue = intervalTimeunit.toMillis(intervalValue);
        this.timerService.createIntervalTimer(0L, intervalValue.longValue(), new TimerConfig((Serializable)((Object)"Docker Cgroup Monitor"), false));
    }

    @Timeout
    public void rotate(Timer timer) {
        block6: {
            if (this.settings.isDockerCgroupEnabled()) {
                LOGGER.log(Level.INFO, "Running DockerCgroupsMonitor");
                try {
                    Long dbDockerMemoryLimit = this.getLimitsLong(this.settings.getDockerCgroupMemoryLimit());
                    Long dbDockerCgroupSoftLimit = this.getLimitsLong(this.settings.getDockerCgroupSoftLimit());
                    Double dbDockerCgroupCpuQuota = this.settings.getDockerCgroupCpuQuota();
                    Integer dbDockerCgroupCpuPeriod = this.settings.getDockerCgroupCpuPeriod();
                    if (dbDockerMemoryLimit == memoryHardLimit && dbDockerCgroupSoftLimit == memorySoftLimit && dbDockerCgroupCpuQuota == cpuQuota && dbDockerCgroupCpuPeriod == cpuPeriod) break block6;
                    memoryHardLimit = dbDockerMemoryLimit;
                    memorySoftLimit = dbDockerCgroupSoftLimit;
                    cpuQuota = dbDockerCgroupCpuQuota;
                    cpuPeriod = dbDockerCgroupCpuPeriod;
                    Long cpuQuotaValue = Math.round(dbDockerCgroupCpuQuota / 100.0 * (double)cpuPeriod.intValue() * (double)Runtime.getRuntime().availableProcessors());
                    String prog = this.settings.getSudoersDir() + "/docker-cgroup-rewrite.sh";
                    ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand(dbDockerMemoryLimit.toString()).addCommand(dbDockerCgroupSoftLimit.toString()).addCommand(cpuQuotaValue.toString()).addCommand(cpuPeriod.toString()).redirectErrorStream(true).setWaitTimeout(60L, TimeUnit.SECONDS).build();
                    ProcessResult processResult = null;
                    try {
                        processResult = this.osProcessExecutor.execute(processDescriptor);
                        if (processResult.getExitCode() != 0) {
                            String errorMsg = "Failed to update docker cgroup values. Exit code: " + processResult.getExitCode() + " Error: stdout: " + processResult.getStdout() + " stderr: " + processResult.getStderr();
                            LOGGER.log(Level.SEVERE, errorMsg);
                            break block6;
                        }
                        LOGGER.log(Level.INFO, "Successfully updated cgroup values");
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "Failed to update docker cgroup values", e);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.SEVERE, "Failed to update docker cgroup values. Could not convert one of the provided values to number", e);
                }
            }
        }
    }

    private Long getLimitsLong(String limit) throws NumberFormatException {
        return Long.parseLong(limit.replaceAll("[^0-9.]", "")) * 0x40000000L;
    }
}

