/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.embedding;

import com.google.common.collect.Sets;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.featurestore.embedding.EmbeddingController;
import io.hops.hopsworks.common.featurestore.embedding.VectorDatabaseClient;
import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.vectordb.Index;
import io.hops.hopsworks.vectordb.VectorDatabaseException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class EmbeddingIndexCleaner {
    private static final Logger LOGGER = Logger.getLogger(EmbeddingIndexCleaner.class.getName());
    @Resource
    private TimerService timerService;
    private Timer timer;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private VectorDatabaseClient vectorDatabaseClient;
    @EJB
    private EmbeddingController embeddingController;
    @EJB
    private PayaraClusterManager payaraClusterManager;

    @PostConstruct
    public void init() {
        this.timer = this.timerService.createIntervalTimer(600000L, 21600000L, new TimerConfig((Serializable)((Object)"EmbeddingIndexCleaner"), false));
    }

    @PreDestroy
    private void destroyTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Timeout
    public void cleanExpiredIndexes() {
        if (!this.payaraClusterManager.amIThePrimary()) {
            return;
        }
        LOGGER.log(Level.INFO, "Checking index to be removed");
        try {
            Set<Index> indexesToRemove = this.getIndexesToRemove();
            for (Index index : indexesToRemove) {
                this.vectorDatabaseClient.getClient().deleteIndex(index);
                LOGGER.log(Level.INFO, "Removed embedding index: " + index.getName());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while cleaning embedding indexes", e);
        }
    }

    private Set<Index> getIndexesToRemove() throws VectorDatabaseException, FeaturestoreException {
        HashSet indexesToRemove = Sets.newHashSet();
        HashSet projectIds = Sets.newHashSet();
        for (Project project : this.projectFacade.findAll()) {
            projectIds.add(project.getId());
        }
        for (Index index : this.vectorDatabaseClient.getClient().getAllIndices()) {
            if (!this.embeddingController.isEmbeddingIndex(index.getName()).booleanValue() || projectIds.contains(this.embeddingController.getProjectId(index.getName()))) continue;
            indexesToRemove.add(index);
        }
        return indexesToRemove;
    }
}

