/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.embedding;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.opensearch.OpenSearchClient;
import io.hops.hopsworks.common.util.LongRunningHttpRequests;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.vectordb.OpensearchVectorDatabase;
import io.hops.hopsworks.vectordb.VectorDatabaseException;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.opensearch.client.RestHighLevelClient;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"OpenSearchClient"})
public class OpensearchVectorDatabaseConstrainedRetry
extends OpensearchVectorDatabase {
    @EJB
    private LongRunningHttpRequests longRunningHttpRequests;
    @EJB
    private Settings settings;
    @EJB
    private OpenSearchClient openSearchClient;

    protected Boolean shouldRetry() {
        return this.longRunningHttpRequests.get() < this.settings.getMaxLongRunningHttpRequests();
    }

    protected void startRetry() {
        this.longRunningHttpRequests.increment();
    }

    protected void doneRetry() {
        this.longRunningHttpRequests.decrement();
    }

    protected RestHighLevelClient getClient() throws VectorDatabaseException {
        try {
            return this.openSearchClient.getClient();
        }
        catch (ServiceDiscoveryException | OpenSearchException e) {
            throw new VectorDatabaseException("Cannot create opensearch client. " + e.getMessage());
        }
    }
}

