/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import io.hops.hopsworks.common.featurestore.featuregroup.EmbeddingFeatureDTO;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Embedding;
import java.util.List;
import java.util.stream.Collectors;

public class EmbeddingDTO {
    private String indexName;
    private String colPrefix;
    private List<EmbeddingFeatureDTO> features;

    public EmbeddingDTO(Embedding embedding) {
        this.indexName = embedding.getVectorDbIndexName();
        this.features = embedding.getEmbeddingFeatures().stream().map(EmbeddingFeatureDTO::new).collect(Collectors.toList());
        this.colPrefix = embedding.getColPrefix();
    }

    public EmbeddingDTO() {
    }

    public EmbeddingDTO(String indexName, String colPrefix, List<EmbeddingFeatureDTO> features) {
        this.indexName = indexName;
        this.colPrefix = colPrefix;
        this.features = features;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getColPrefix() {
        return this.colPrefix;
    }

    public List<EmbeddingFeatureDTO> getFeatures() {
        return this.features;
    }
}

