/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hopsworks.common.featurestore.featuregroup.ModelDto;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.EmbeddingFeature;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.SimilarityFunctionType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EmbeddingFeatureDTO {
    private String name;
    private SimilarityFunctionType similarityFunctionType;
    private Integer dimension;
    private ModelDto model;

    public EmbeddingFeatureDTO(String name, SimilarityFunctionType similarityFunctionType, Integer dimension) {
        this.name = name;
        this.similarityFunctionType = similarityFunctionType;
        this.dimension = dimension;
    }

    public EmbeddingFeatureDTO(EmbeddingFeature feature) {
        this.name = feature.getName();
        this.similarityFunctionType = feature.getSimilarityFunctionType();
        this.dimension = feature.getDimension();
        if (feature.getModelVersion() != null) {
            this.model = new ModelDto(feature.getModelVersion().getModel().getProject().getId(), feature.getModelVersion().getModel().getName(), feature.getModelVersion().getVersion());
        }
    }

    public EmbeddingFeatureDTO() {
    }

    public EmbeddingFeatureDTO(String name, SimilarityFunctionType similarityFunctionType, Integer dimension, ModelDto model) {
        this.name = name;
        this.similarityFunctionType = similarityFunctionType;
        this.dimension = dimension;
        this.model = model;
    }

    public String getName() {
        return this.name;
    }

    public SimilarityFunctionType getSimilarityFunctionType() {
        return this.similarityFunctionType;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public ModelDto getModel() {
        return this.model;
    }
}

