/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.google.common.collect.Lists;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class FeaturegroupFacade
extends AbstractFacade<Featuregroup> {
    private static final Logger LOGGER = Logger.getLogger(FeaturegroupFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    @EJB
    private Settings settings;

    public FeaturegroupFacade() {
        super(Featuregroup.class);
    }

    public Optional<Featuregroup> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("Featuregroup.findById", Featuregroup.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<Featuregroup> findByIdAndFeaturestore(Integer id, Featurestore featurestore) {
        try {
            return Optional.of(this.em.createNamedQuery("Featuregroup.findByFeaturestoreAndId", Featuregroup.class).setParameter("featurestore", (Object)featurestore).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<Featuregroup> findByNameAndFeaturestore(String name, Featurestore featurestore) {
        return this.em.createNamedQuery("Featuregroup.findByFeaturestoreAndName", Featuregroup.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).getResultList();
    }

    public List<Featuregroup> findByNameAndFeaturestoreOrderedDescVersion(String name, Featurestore featurestore) {
        return this.em.createNamedQuery("Featuregroup.findByFeaturestoreAndNameOrderedByDescVersion", Featuregroup.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).getResultList();
    }

    public Optional<Featuregroup> findByNameVersionAndFeaturestore(String name, Integer version, Featurestore featurestore) {
        try {
            return Optional.of(this.em.createNamedQuery("Featuregroup.findByFeaturestoreAndNameVersion", Featuregroup.class).setParameter("featurestore", (Object)featurestore).setParameter("version", (Object)version).setParameter("name", (Object)name).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<Featuregroup> findAll() {
        TypedQuery q = this.em.createNamedQuery("Featuregroup.findAll", Featuregroup.class);
        return q.getResultList();
    }

    public AbstractFacade.CollectionInfo findByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        return new AbstractFacade.CollectionInfo(this.countByFeatureStore(featurestore, queryParam), this.getByFeatureStore(featurestore, queryParam));
    }

    public List<Featuregroup> getByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT fg FROM Featuregroup fg ", queryParam != null ? queryParam.getFilters() : null, queryParam != null ? queryParam.getSorts() : null, "fg.featurestore = :featurestore AND (fg.onDemandFeaturegroup IS NOT null OR fg.cachedFeaturegroup IS NOT null OR fg.streamFeatureGroup IS NOT null)");
        TypedQuery query = this.em.createQuery(queryStr, Featuregroup.class).setParameter("featurestore", (Object)featurestore);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
            this.setOffsetAndLim(queryParam.getOffset(), queryParam.getLimit(), (Query)query);
        }
        return query.getResultList();
    }

    public Long countByFeatureStore(Featurestore featurestore, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT count(fg.id) FROM Featuregroup fg ", queryParam != null ? queryParam.getFilters() : null, null, "fg.featurestore = :featurestore AND (fg.onDemandFeaturegroup IS NOT null OR fg.cachedFeaturegroup IS NOT null OR fg.streamFeatureGroup IS NOT null)");
        TypedQuery query = this.em.createQuery(queryStr, Long.class).setParameter("featurestore", (Object)featurestore);
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), (Query)query);
        }
        return (Long)query.getSingleResult();
    }

    public List<Featuregroup> findByStorageConnectors(List<FeaturestoreConnector> storageConnectors) {
        if (storageConnectors.size() > this.settings.getSQLMaxSelectIn()) {
            ArrayList<Featuregroup> result = new ArrayList<Featuregroup>();
            for (List partition : Lists.partition(storageConnectors, (int)this.settings.getSQLMaxSelectIn())) {
                TypedQuery query = this.em.createNamedQuery("Featuregroup.findByStorageConnectors", Featuregroup.class);
                query.setParameter("storageConnectors", (Object)partition);
                result.addAll(query.getResultList());
            }
            return result;
        }
        TypedQuery query = this.em.createNamedQuery("Featuregroup.findByStorageConnectors", Featuregroup.class);
        query.setParameter("storageConnectors", storageConnectors);
        return query.getResultList();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(Featuregroup featuregroup) {
        try {
            this.em.persist((Object)featuregroup);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new Featuregroup", cve);
        }
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Featuregroup updateFeaturegroupMetadata(Featuregroup featuregroup) {
        this.em.merge((Object)featuregroup);
        return featuregroup;
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filters, Query q) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filters) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filter, Query q) {
        switch (Filters.valueOf(filter.getValue())) {
            case NAME: 
            case NAME_LIKE: {
                q.setParameter(filter.getField(), (Object)filter.getParam());
                break;
            }
            case VERSION: {
                q.setParameter(filter.getField(), (Object)Integer.valueOf(filter.getParam()));
                break;
            }
        }
    }

    public static enum Sorts {
        NAME("NAME", "fg.name", "ASC"),
        VERSION("VERSION", "fg.version", "ASC"),
        CREATION("CREATION", "fg.created", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Filters {
        NAME("NAME", "fg.name = :name", "name", ""),
        NAME_LIKE("NAME_LIKE", "fg.name LIKE CONCAT('%', :name, '%') ", "name", ""),
        VERSION("VERSION", "fg.version = :version", "version", ""),
        LATEST_VERSION("LATEST_VERSION", String.format("%1$s.version = ( SELECT MAX(%2$s.version) FROM Featuregroup %2$s WHERE %1$s.name = %2$s.name AND %1$s.featurestore = %2$s.featurestore ) ", "fg", "fg2"), null, null);

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }
}

