/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.cached;

import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.FeatureGroupCommitFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.FeatureGroupCommit;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureGroupCommitController {
    @EJB
    private FeatureGroupCommitFacade featureGroupCommitFacade;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;

    public FeatureGroupCommit createHudiFeatureGroupCommit(Users user, Featuregroup featuregroup, Long commitTime, Long rowsUpdated, Long rowsInserted, Long rowsDeleted, Integer validationId, Long lastActiveCommitTime) {
        FeatureGroupCommit featureGroupCommit = new FeatureGroupCommit(featuregroup.getId(), commitTime);
        featureGroupCommit.setCommittedOn(new Timestamp(commitTime));
        featureGroupCommit.setNumRowsUpdated(rowsUpdated);
        featureGroupCommit.setNumRowsInserted(rowsInserted);
        featureGroupCommit.setNumRowsDeleted(rowsDeleted);
        featureGroupCommit.setArchived(Boolean.valueOf(false));
        if (validationId == null || validationId > 0) {
            // empty if block
        }
        featureGroupCommit = (FeatureGroupCommit)this.featureGroupCommitFacade.update(featureGroupCommit);
        if (lastActiveCommitTime != null) {
            this.featureGroupCommitFacade.markArchived(featuregroup.getId(), new Timestamp(lastActiveCommitTime));
        }
        this.fsActivityFacade.logCommitActivity(user, featuregroup, featureGroupCommit);
        return featureGroupCommit;
    }

    public Optional<FeatureGroupCommit> findCommitByDate(Featuregroup featuregroup, Long commitTimestamp) {
        if (commitTimestamp != null) {
            return this.featureGroupCommitFacade.findClosestDateCommit(featuregroup.getId(), commitTimestamp);
        }
        return this.featureGroupCommitFacade.findLatestDateCommit(featuregroup.getId());
    }

    public Integer countCommitsInRange(Featuregroup featuregroup, Long startTimestamp, Long endTimestamp) {
        return this.featureGroupCommitFacade.countCommitsInRange(featuregroup.getId(), startTimestamp, endTimestamp);
    }

    public Optional<Pair<FeatureGroupCommit, FeatureGroupCommit>> findEarliestAndLatestCommitsInRange(Featuregroup featuregroup, Long startTimestamp, Long endTimestamp) {
        Optional<FeatureGroupCommit> earliestCommit = this.featureGroupCommitFacade.findEarliestCommitInRange(featuregroup.getId(), startTimestamp, endTimestamp);
        Optional<FeatureGroupCommit> latestCommit = this.featureGroupCommitFacade.findLatestCommitInRange(featuregroup.getId(), startTimestamp, endTimestamp);
        if (latestCommit.isPresent() && !earliestCommit.isPresent()) {
            earliestCommit = latestCommit;
        } else if (!latestCommit.isPresent() && earliestCommit.isPresent()) {
            latestCommit = earliestCommit;
        }
        return latestCommit.isPresent() ? Optional.of(new Pair((Object)earliestCommit.get(), (Object)latestCommit.get())) : Optional.empty();
    }

    public Optional<FeatureGroupCommit> findFirstCommit(Featuregroup featuregroup) {
        return this.featureGroupCommitFacade.findEarliestDateCommit(featuregroup.getId());
    }

    public AbstractFacade.CollectionInfo getCommitDetails(Integer featureGroupId, Integer limit, Integer offset, Set<? extends AbstractFacade.SortBy> sort, Set<? extends AbstractFacade.FilterBy> filters) {
        if (filters == null || filters.isEmpty()) {
            return this.featureGroupCommitFacade.getCommitDetails(featureGroupId, limit, offset, sort);
        }
        return this.featureGroupCommitFacade.getCommitDetailsByDate(featureGroupId, limit, offset, sort, filters);
    }

    public void deleteFeatureGroupCommits(Featuregroup featuregroup) {
        List featureGroupCommits;
        while (!(featureGroupCommits = this.featureGroupCommitFacade.getCommitDetails(featuregroup.getId(), AbstractFacade.BATCH_SIZE, 0, null).getItems()).isEmpty()) {
            this.featureGroupCommitFacade.removeBatch(featureGroupCommits);
        }
    }

    public Pair<Long, Long> getStartEndCommitTimesByWindowTime(Featuregroup featuregroup, Long startTime, Long endTime) throws FeaturestoreException {
        if (endTime == null || startTime == null || startTime == 0L) {
            startTime = 0L;
            Optional<FeatureGroupCommit> lastCommit = this.findCommitByDate(featuregroup, endTime);
            if (!lastCommit.isPresent()) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_GROUP_COMMIT_NOT_FOUND, Level.WARNING, "No feature group commits found before commit time '" + endTime + "'");
            }
            return new Pair((Object)startTime, (Object)lastCommit.get().getCommittedOn());
        }
        if (!endTime.equals(startTime)) {
            Optional<Pair<FeatureGroupCommit, FeatureGroupCommit>> startEndCommits = this.findEarliestAndLatestCommitsInRange(featuregroup, startTime, endTime);
            if (!startEndCommits.isPresent()) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_GROUP_COMMIT_NOT_FOUND, Level.WARNING, "The commit window provided does not contain any feature group commits");
            }
            return new Pair((Object)((FeatureGroupCommit)startEndCommits.get().getValue0()).getCommittedOn(), (Object)((FeatureGroupCommit)startEndCommits.get().getValue1()).getCommittedOn());
        }
        Optional<FeatureGroupCommit> commit = this.findCommitByDate(featuregroup, endTime);
        if (!commit.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_GROUP_COMMIT_NOT_FOUND, Level.WARNING, "No feature group commits found before commit time '" + endTime + "'");
        }
        startTime = endTime = commit.get().getCommittedOn();
        return new Pair((Object)startTime, (Object)endTime);
    }
}

