/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup.online;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.hive.serde2.thrift.Type;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AvroSchemaConstructorController {
    public String constructSchema(Featuregroup featuregroup, List<FeatureGroupFeatureDTO> schema) throws FeaturestoreException {
        String featureGroupEntityName = Utils.getFeaturegroupName(featuregroup);
        String featureStoreName = Utils.getFeaturestoreName(featuregroup.getFeaturestore().getProject());
        SchemaBuilder.TypeBuilder avroSchema = SchemaBuilder.builder();
        SchemaBuilder.FieldAssembler recordSchema = ((SchemaBuilder.RecordBuilder)avroSchema.record(featureGroupEntityName).namespace(featureStoreName)).fields();
        for (FeatureGroupFeatureDTO feature : schema) {
            recordSchema = recordSchema.name(feature.getName()).type(this.toAvro(feature.getType(), true, feature.getName())).noDefault();
        }
        return ((Schema)recordSchema.endRecord()).toString(true);
    }

    public Schema toAvroPrimitiveType(String hiveType) throws FeaturestoreException {
        SchemaBuilder.TypeBuilder avroSchema = SchemaBuilder.builder();
        switch (Type.getType((String)hiveType.toUpperCase())) {
            case INT_TYPE: 
            case SMALLINT_TYPE: 
            case TINYINT_TYPE: {
                return (Schema)avroSchema.intType();
            }
            case BOOLEAN_TYPE: {
                return (Schema)avroSchema.booleanType();
            }
            case BINARY_TYPE: {
                return (Schema)avroSchema.bytesType();
            }
            case BIGINT_TYPE: {
                return (Schema)avroSchema.longType();
            }
            case FLOAT_TYPE: {
                return (Schema)avroSchema.floatType();
            }
            case DOUBLE_TYPE: {
                return (Schema)avroSchema.doubleType();
            }
            case STRING_TYPE: {
                return (Schema)avroSchema.stringType();
            }
            case DATE_TYPE: {
                return LogicalTypes.date().addToSchema((Schema)avroSchema.intType());
            }
            case TIMESTAMP_TYPE: {
                return LogicalTypes.timestampMicros().addToSchema((Schema)avroSchema.longType());
            }
            case DECIMAL_TYPE: {
                String precisionScale = hiveType.substring(7);
                if (!precisionScale.startsWith("(") || !precisionScale.endsWith(")")) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_MALFORMED_SCHEMA, Level.FINE, "The provided type is malformed: " + hiveType);
                }
                precisionScale = precisionScale.substring(1, precisionScale.length() - 1);
                String[] precisionScaleArray = precisionScale.split(",", 2);
                return LogicalTypes.decimal((int)Integer.parseInt(precisionScaleArray[0]), (int)Integer.parseInt(precisionScaleArray[1])).addToSchema((Schema)avroSchema.bytesType());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_PRIMITIVE_TYPE_NOT_SUPPORTED, Level.FINE, "The provided type is not valid or not supported: " + hiveType);
    }

    public Schema toAvro(String hiveType, boolean nullable, String nameSpace) throws FeaturestoreException {
        Schema result;
        SchemaBuilder.TypeBuilder avroSchema = SchemaBuilder.builder();
        String sanitizedHiveType = hiveType.replaceAll("\\s+", "").toLowerCase();
        if (sanitizedHiveType.startsWith(Type.ARRAY_TYPE.getName().toLowerCase())) {
            result = (Schema)avroSchema.array().items(this.toAvro(this.getInnerType(sanitizedHiveType, 5), nullable, nameSpace));
        } else if (sanitizedHiveType.startsWith(Type.MAP_TYPE.getName().toLowerCase())) {
            String[] mapTypes = this.getMapTypes(this.getInnerType(sanitizedHiveType, 3));
            if (!mapTypes[0].equals(Type.STRING_TYPE.getName().toLowerCase())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_MAP_STRING_KEY, Level.FINE, "The type of Map keys has to be STRING, but found: " + mapTypes[0]);
            }
            result = (Schema)avroSchema.map().values(this.toAvro(mapTypes[1], nullable, nameSpace));
        } else if (sanitizedHiveType.startsWith(Type.STRUCT_TYPE.getName().toLowerCase())) {
            String recordName = "r" + Math.abs((long)sanitizedHiveType.hashCode());
            String childNameSpace = !Strings.isNullOrEmpty((String)nameSpace) ? nameSpace + "." + recordName : recordName;
            SchemaBuilder.FieldAssembler record = ((SchemaBuilder.RecordBuilder)avroSchema.record(recordName).namespace(nameSpace)).fields();
            for (String field : this.parseStructFields(this.getInnerType(sanitizedHiveType, 6))) {
                String[] structField = this.getStructField(field);
                if (structField.length != 2) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_MALFORMED_SCHEMA, Level.FINE, "Failed to convert STRUCT type: " + structField);
                }
                record.name(structField[0]).type(this.toAvro(structField[1], nullable, childNameSpace)).noDefault();
            }
            result = (Schema)record.endRecord();
        } else {
            result = this.toAvroPrimitiveType(sanitizedHiveType);
        }
        if (nullable) {
            return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), result});
        }
        return result;
    }

    public String getInnerType(String hiveType, int offset) throws FeaturestoreException {
        String innerType = hiveType.substring(offset);
        if (innerType.startsWith("<") && innerType.endsWith(">")) {
            return innerType.substring(1, innerType.length() - 1);
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_MALFORMED_SCHEMA, Level.FINE, "The provided type is malformed: " + hiveType);
    }

    public String[] getMapTypes(String hiveType) {
        return hiveType.split(",", 2);
    }

    public List<String> parseStructFields(String structFields) throws FeaturestoreException {
        Stack<Character> brackets = new Stack<Character>();
        StringBuilder field = new StringBuilder();
        ArrayList<String> fields = new ArrayList<String>();
        char[] cArray = structFields.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            if (ch.equals(Character.valueOf('<'))) {
                brackets.push(Character.valueOf('<'));
                field.append(ch);
                continue;
            }
            if (ch.equals(Character.valueOf('>'))) {
                try {
                    brackets.pop();
                }
                catch (EmptyStackException e) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_MALFORMED_SCHEMA, Level.FINE, "The provided struct field type is malformed: " + structFields);
                }
                field.append(ch);
                continue;
            }
            if (ch.equals(Character.valueOf(',')) && brackets.empty()) {
                fields.add(field.toString());
                field = new StringBuilder();
                continue;
            }
            field.append(ch);
        }
        fields.add(field.toString());
        if (brackets.empty()) {
            return fields;
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.AVRO_MALFORMED_SCHEMA, Level.FINE, "The provided struct field type is malformed: " + structFields);
    }

    public String[] getStructField(String structField) {
        return structField.split(":", 2);
    }
}

