/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.alert;

import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.common.alert.AlertController;
import io.hops.hopsworks.common.api.ResourceRequest;
import io.hops.hopsworks.common.dao.project.alert.ProjectServiceAlertsFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.datavalidation.FeatureGroupAlertFacade;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewAlertFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.alert.FeatureStoreAlert;
import io.hops.hopsworks.persistence.entity.featurestore.alert.FeatureStoreAlertStatus;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringConfiguration;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.result.FeatureMonitoringResult;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlertStatus;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureMonitoringAlertController {
    @EJB
    private FeaturestoreController featurestoreController;
    @EJB
    private AlertController alertController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeatureGroupAlertFacade featureGroupAlertFacade;
    @EJB
    private ProjectServiceAlertsFacade projectServiceAlertsFacade;
    @EJB
    private FeatureViewAlertFacade featureViewAlertFacade;

    public void triggerAlertsByStatus(FeatureMonitoringConfiguration config, FeatureMonitoringResult result) throws FeaturestoreException {
        List<PostableAlert> postableAlerts;
        Project project;
        this.validateInput(config, result);
        if (config.getFeatureGroup() != null) {
            project = config.getFeatureGroup().getFeaturestore().getProject();
            String fsName = this.featurestoreController.getOfflineFeaturestoreDbName(config.getFeatureGroup().getFeaturestore());
            postableAlerts = this.getValidPostableAlerts(project, fsName, config, result, ResourceRequest.Name.FEATUREGROUPS);
        } else {
            project = config.getFeatureView().getFeaturestore().getProject();
            String fsName = this.featurestoreController.getOfflineFeaturestoreDbName(config.getFeatureView().getFeaturestore());
            postableAlerts = this.getValidPostableAlerts(project, fsName, config, result, ResourceRequest.Name.FEATUREVIEW);
        }
        this.alertController.sendFeatureMonitorAlert(postableAlerts, project, config.getName());
    }

    private List<PostableAlert> getValidPostableAlerts(Project project, String fsName, FeatureMonitoringConfiguration configuration, FeatureMonitoringResult result, ResourceRequest.Name entityType) {
        FeatureStoreAlert featureStoreAlert;
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        FeatureStoreAlertStatus alertStatus = FeatureStoreAlertStatus.fromBooleanFeatureMonitorResultStatus((Boolean)result.getShiftDetected());
        ProjectServiceAlertStatus projectAlertStatus = ProjectServiceAlertStatus.fromBooleanFeatureMonitorResultStatus((Boolean)result.getShiftDetected());
        ProjectServiceAlert projectAlert = this.projectServiceAlertsFacade.findByProjectAndStatus(project, projectAlertStatus);
        if (projectAlert != null) {
            postableAlerts.add(this.geProjectPostableAlert(project, fsName, projectAlert, configuration, result));
        }
        if ((featureStoreAlert = this.retrieveAlert(configuration, entityType, alertStatus)) != null) {
            postableAlerts.add(this.getFeatureMonitorAlert(project, fsName, featureStoreAlert, entityType, configuration, result));
        }
        return postableAlerts;
    }

    private FeatureStoreAlert retrieveAlert(FeatureMonitoringConfiguration configuration, ResourceRequest.Name entityType, FeatureStoreAlertStatus alertStatus) {
        if (entityType.equals((Object)ResourceRequest.Name.FEATUREGROUPS)) {
            return this.featureGroupAlertFacade.findByFeatureGroupAndStatus(configuration.getFeatureGroup(), alertStatus);
        }
        return this.featureViewAlertFacade.findByFeatureViewAndStatus(configuration.getFeatureView(), alertStatus);
    }

    private PostableAlert geProjectPostableAlert(Project project, String fsName, ProjectServiceAlert projectAlert, FeatureMonitoringConfiguration configuration, FeatureMonitoringResult result) {
        return this.alertController.getPostableFeatureMonitorAlert(project, projectAlert, configuration.getName(), result.getId(), this.constructAlertSummary(configuration, result), this.constructAlertDescription(configuration), fsName);
    }

    private PostableAlert getFeatureMonitorAlert(Project project, String fsName, FeatureStoreAlert alert, ResourceRequest.Name entityType, FeatureMonitoringConfiguration configuration, FeatureMonitoringResult result) {
        return this.alertController.getPostableFeatureMonitorAlert(project, alert, entityType, configuration.getName(), result.getId(), this.constructAlertSummary(configuration, result), this.constructAlertDescription(configuration), fsName);
    }

    private String constructAlertSummary(FeatureMonitoringConfiguration configuration, FeatureMonitoringResult result) {
        return String.format("Feature name: %s; Shift detected: %s; Difference: %s", configuration.getFeatureName(), result.getShiftDetected(), result.getDifference());
    }

    private String constructAlertDescription(FeatureMonitoringConfiguration configuration) {
        return String.format("FeatureMonitoring Config Name: %s; Monitoring Type: %s", configuration.getName(), configuration.getFeatureMonitoringType());
    }

    public void validateInput(FeatureMonitoringConfiguration config, FeatureMonitoringResult result) throws FeaturestoreException {
        if (config == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ALERT_ILLEGAL_ARGUMENT, Level.SEVERE, "Feature Monitoring Config should not be null.");
        }
        if (result == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ALERT_ILLEGAL_ARGUMENT, Level.SEVERE, "Feature Monitoring Result should not be null.");
        }
        if (Boolean.FALSE.equals(config.getJobSchedule().getEnabled())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ALERT_ILLEGAL_ARGUMENT, Level.FINE, "Feature Monitoring Config is disabled, skipping triggering alert.");
        }
    }
}

