/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuremonitoring.config;

import io.hops.hopsworks.common.api.ResourceRequest;
import io.hops.hopsworks.common.featurestore.app.FsJobManagerController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuremonitoring.config.FeatureMonitoringConfigurationFacade;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewController;
import io.hops.hopsworks.common.jobs.JobController;
import io.hops.hopsworks.common.jobs.scheduler.JobScheduleV2Controller;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.config.FeatureMonitoringConfiguration;
import io.hops.hopsworks.persistence.entity.featurestore.featuremonitoring.descriptivestatistics.DescriptiveStatisticsComparisonConfig;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.jobs.description.Jobs;
import io.hops.hopsworks.persistence.entity.jobs.scheduler.JobScheduleV2;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeatureMonitoringConfigurationController {
    private static final Logger LOGGER = Logger.getLogger(FeatureMonitoringConfigurationController.class.getName());
    @EJB
    FeatureMonitoringConfigurationFacade featureMonitoringConfigurationFacade;
    @EJB
    FeaturegroupController featureGroupController;
    @EJB
    FeatureViewController featureViewController;
    @EJB
    FsJobManagerController fsJobManagerController;
    @EJB
    JobController jobController;
    @EJB
    JobScheduleV2Controller scheduleV2Controller;

    public List<FeatureMonitoringConfiguration> getFeatureMonitoringConfigurationByEntityAndFeatureName(Featurestore featureStore, ResourceRequest.Name entityType, Integer entityId, String featureName) throws FeaturestoreException {
        Featuregroup featureGroup = null;
        FeatureView featureView = null;
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            featureGroup = this.featureGroupController.getFeaturegroupById(featureStore, entityId);
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            featureView = this.featureViewController.getByIdAndFeatureStore(entityId, featureStore);
        }
        List<FeatureMonitoringConfiguration> configs = new ArrayList<FeatureMonitoringConfiguration>();
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            configs = this.featureMonitoringConfigurationFacade.findByFeatureGroupAndFeatureName(featureGroup, featureName);
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            configs = this.featureMonitoringConfigurationFacade.findByFeatureViewAndFeatureName(featureView, featureName);
        }
        return configs;
    }

    public List<FeatureMonitoringConfiguration> getFeatureMonitoringConfigurationByEntity(Featurestore featureStore, ResourceRequest.Name entityType, Integer entityId) throws FeaturestoreException {
        Featuregroup featureGroup = null;
        FeatureView featureView = null;
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            featureGroup = this.featureGroupController.getFeaturegroupById(featureStore, entityId);
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            featureView = this.featureViewController.getByIdAndFeatureStore(entityId, featureStore);
        }
        List<FeatureMonitoringConfiguration> configs = new ArrayList<FeatureMonitoringConfiguration>();
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            configs = this.featureMonitoringConfigurationFacade.findByFeatureGroup(featureGroup);
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            configs = this.featureMonitoringConfigurationFacade.findByFeatureView(featureView);
        }
        return configs;
    }

    public FeatureMonitoringConfiguration getFeatureMonitoringConfigurationByConfigId(Integer configId) throws FeaturestoreException {
        Optional<FeatureMonitoringConfiguration> optConfig = this.featureMonitoringConfigurationFacade.findById(configId);
        if (!optConfig.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_MONITORING_ENTITY_NOT_FOUND, Level.WARNING, String.format("Feature Monitoring Config with id %d not found.", configId));
        }
        return optConfig.get();
    }

    public FeatureMonitoringConfiguration getFeatureMonitoringConfigurationByEntityAndName(Featurestore featureStore, ResourceRequest.Name entityType, Integer entityId, String name) throws FeaturestoreException {
        Optional<Object> optConfig = Optional.empty();
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            Featuregroup featureGroup = this.featureGroupController.getFeaturegroupById(featureStore, entityId);
            optConfig = this.featureMonitoringConfigurationFacade.findByFeatureGroupAndName(featureGroup, name);
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            FeatureView featureView = this.featureViewController.getByIdAndFeatureStore(entityId, featureStore);
            optConfig = this.featureMonitoringConfigurationFacade.findByFeatureViewAndName(featureView, name);
        }
        if (!optConfig.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_MONITORING_ENTITY_NOT_FOUND, Level.WARNING, String.format("Feature Monitoring Config with name %s not found.", name));
        }
        return (FeatureMonitoringConfiguration)optConfig.get();
    }

    public FeatureMonitoringConfiguration createFeatureMonitoringConfiguration(Featurestore featureStore, Users user, ResourceRequest.Name entityType, FeatureMonitoringConfiguration config) throws FeaturestoreException, JobException {
        Featuregroup featureGroup = config.getFeatureGroup();
        FeatureView featureView = config.getFeatureView();
        String entityName = null;
        Integer entityVersion = null;
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            entityName = featureGroup.getName();
            entityVersion = featureGroup.getVersion();
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            entityName = featureView.getName();
            entityVersion = featureView.getVersion();
        }
        Jobs monitoringJob = this.fsJobManagerController.setupFeatureMonitoringJob(user, featureStore.getProject(), entityType, entityName, entityVersion, config.getName());
        config.setJob(monitoringJob);
        JobScheduleV2 schedule = config.getJobSchedule();
        schedule.setJob(monitoringJob);
        config.setJobSchedule(this.scheduleV2Controller.createSchedule(schedule));
        return (FeatureMonitoringConfiguration)this.featureMonitoringConfigurationFacade.update(config);
    }

    public void deleteFeatureMonitoringConfiguration(Integer configId) throws FeaturestoreException {
        FeatureMonitoringConfiguration config = this.getFeatureMonitoringConfigurationByConfigId(configId);
        this.featureMonitoringConfigurationFacade.remove(config);
    }

    public FeatureMonitoringConfiguration updateFeatureMonitoringConfiguration(Integer configId, FeatureMonitoringConfiguration config) throws FeaturestoreException, JobException {
        Optional<FeatureMonitoringConfiguration> optConfig = this.featureMonitoringConfigurationFacade.findById(configId);
        if (!optConfig.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_MONITORING_ENTITY_NOT_FOUND, Level.WARNING, String.format("Feature Monitoring Config with id %d not found.", configId));
        }
        FeatureMonitoringConfiguration newConfig = this.setAllowedFeatureMonitoringConfigurationUpdates(optConfig.get(), config);
        this.featureMonitoringConfigurationFacade.update(newConfig);
        return newConfig;
    }

    public FeatureMonitoringConfiguration setAllowedFeatureMonitoringConfigurationUpdates(FeatureMonitoringConfiguration config, FeatureMonitoringConfiguration newConfig) throws JobException {
        config.setDescription(newConfig.getDescription());
        JobScheduleV2 schedule = newConfig.getJobSchedule();
        schedule.setId(config.getJobSchedule().getId());
        schedule.setEnabled(newConfig.getJobSchedule().getEnabled());
        config.setJobSchedule(this.scheduleV2Controller.updateSchedule(schedule));
        DescriptiveStatisticsComparisonConfig statsConfig = config.getDsComparisonConfig();
        statsConfig.setThreshold(newConfig.getDsComparisonConfig().getThreshold());
        statsConfig.setStrict(newConfig.getDsComparisonConfig().getStrict());
        config.setDsComparisonConfig(statsConfig);
        return config;
    }

    public Jobs setupFeatureMonitoringJob(Project project, Users user, Featurestore featureStore, ResourceRequest.Name entityType, Integer entityId, String configName) throws FeaturestoreException, JobException {
        String entityName = "";
        Integer entityVersion = -1;
        if (entityType == ResourceRequest.Name.FEATUREGROUPS) {
            Featuregroup featureGroup = this.featureGroupController.getFeaturegroupById(featureStore, entityId);
            entityName = featureGroup.getName();
            entityVersion = featureGroup.getVersion();
        } else if (entityType == ResourceRequest.Name.FEATUREVIEW) {
            FeatureView featureView = this.featureViewController.getByIdAndFeatureStore(entityId, featureStore);
            entityName = featureView.getName();
            entityVersion = featureView.getVersion();
        }
        return this.fsJobManagerController.setupFeatureMonitoringJob(user, project, entityType, entityName, entityVersion, configName);
    }
}

