/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.query.ConstructorController;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.QueryController;
import io.hops.hopsworks.common.featurestore.query.filter.Filter;
import io.hops.hopsworks.common.featurestore.query.filter.FilterDTO;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogic;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogicDTO;
import io.hops.hopsworks.common.featurestore.query.filter.FilterValue;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlCondition;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlFilterLogic;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.json.JSONArray;
import org.json.JSONTokener;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FilterController {
    @EJB
    private ConstructorController constructorController;
    @EJB
    private QueryController queryController;
    @EJB
    private FeaturegroupController featuregroupController;
    private ObjectMapper objectMapper = new ObjectMapper();
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public FilterController() {
    }

    public FilterController(ConstructorController constructorController) {
        this.constructorController = constructorController;
    }

    public FilterLogic convertFilterLogic(Project project, Users users, Query query, FilterLogicDTO filterLogicDTO) throws FeaturestoreException {
        Map fgLookup = this.queryController.getFeatureGroups(query).stream().collect(Collectors.toMap(Featuregroup::getId, Function.identity()));
        HashMap availableFeatureLookup = Maps.newHashMap();
        for (Featuregroup featuregroup : fgLookup.values()) {
            availableFeatureLookup.put(featuregroup.getId(), this.featuregroupController.getFeatures(featuregroup, project, users).stream().map(f -> new Feature((FeatureGroupFeatureDTO)f, featuregroup)).collect(Collectors.toList()));
        }
        return this.convertFilterLogic(filterLogicDTO, availableFeatureLookup);
    }

    public FilterLogic convertFilterLogic(FilterLogicDTO filterLogicDTO, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        FilterLogic filterLogic = new FilterLogic(filterLogicDTO.getType());
        this.validateFilterLogicDTO(filterLogicDTO);
        if (filterLogicDTO.getLeftFilter() != null) {
            filterLogic.setLeftFilter(this.convertFilter(filterLogicDTO.getLeftFilter(), availableFeatureLookup));
        }
        if (filterLogicDTO.getRightFilter() != null) {
            filterLogic.setRightFilter(this.convertFilter(filterLogicDTO.getRightFilter(), availableFeatureLookup));
        }
        if (filterLogicDTO.getLeftLogic() != null) {
            filterLogic.setLeftLogic(this.convertFilterLogic(filterLogicDTO.getLeftLogic(), availableFeatureLookup));
        }
        if (filterLogicDTO.getRightLogic() != null) {
            filterLogic.setRightLogic(this.convertFilterLogic(filterLogicDTO.getRightLogic(), availableFeatureLookup));
        }
        return filterLogic;
    }

    public String convertToEventTimeFeatureValue(Feature feature, Date date) throws FeaturestoreException {
        String timeType = feature.getType();
        this.timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if ("date".equals(timeType)) {
            return this.dateFormat.format(date);
        }
        if ("timestamp".equals(timeType)) {
            return this.timestampFormat.format(date);
        }
        return String.valueOf(date.getTime());
    }

    void validateFilterLogicDTO(FilterLogicDTO filterLogicDTO) throws FeaturestoreException {
        if (filterLogicDTO.getLeftFilter() != null && filterLogicDTO.getLeftLogic() != null || filterLogicDTO.getRightFilter() != null && filterLogicDTO.getRightLogic() != null || filterLogicDTO.getType() == SqlFilterLogic.SINGLE && (filterLogicDTO.getLeftFilter() == null || filterLogicDTO.getLeftLogic() != null || filterLogicDTO.getRightFilter() != null || filterLogicDTO.getRightLogic() != null)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FILTER_ARGUMENTS, Level.FINE, "The provided filters for the Query are malformed, please do not access private attributes, contact maintainers with reproducible example.");
        }
    }

    Filter convertFilter(FilterDTO filterDTO, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        return new Filter(Arrays.asList(this.findFilteredFeature(filterDTO.getFeature(), availableFeatureLookup)), filterDTO.getCondition(), this.convertFilterValue(filterDTO.getValue(), availableFeatureLookup));
    }

    FilterValue convertFilterValue(String value, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        if (value == null) {
            return new FilterValue(null);
        }
        try {
            FeatureGroupFeatureDTO featureDto = (FeatureGroupFeatureDTO)this.objectMapper.readValue(value, FeatureGroupFeatureDTO.class);
            if (featureDto == null) {
                return new FilterValue("null");
            }
            Feature feature = this.findFilteredFeature(featureDto, availableFeatureLookup);
            return new FilterValue(feature.getFeatureGroup().getId(), feature.getFgAlias(), feature.getName());
        }
        catch (IOException e) {
            return new FilterValue(value);
        }
    }

    Feature findFilteredFeature(FeatureGroupFeatureDTO featureDTO, Map<Integer, List<Feature>> availableFeatureLookup) throws FeaturestoreException {
        Optional<Object> feature = Optional.empty();
        if (featureDTO.getFeatureGroupId() != null) {
            if (!availableFeatureLookup.containsKey(featureDTO.getFeatureGroupId())) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Filtered feature : '" + featureDTO.getName() + "' not found in main query.");
            }
            feature = availableFeatureLookup.get(featureDTO.getFeatureGroupId()).stream().filter(af -> af.getName().equals(featureDTO.getName())).findFirst();
        } else {
            Map.Entry<Integer, List<Feature>> pair;
            Iterator<Map.Entry<Integer, List<Feature>>> iterator = availableFeatureLookup.entrySet().iterator();
            while (iterator.hasNext() && !(feature = (pair = iterator.next()).getValue().stream().filter(af -> af.getName().equals(featureDTO.getName())).findFirst()).isPresent()) {
            }
        }
        return (Feature)feature.orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_DOES_NOT_EXIST, Level.FINE, "Filtered feature: `" + featureDTO.getName() + "` not found in any of the feature groups."));
    }

    public SqlNode generateFilterLogicNode(FilterLogic filterLogic, boolean online) {
        return this.generateFilterLogicNode(filterLogic, online, true, false);
    }

    public SqlNode generateFilterLogicNode(FilterLogic filterLogic, boolean online, boolean checkForInNull, boolean usePitAlias) {
        if (filterLogic.getType() == SqlFilterLogic.SINGLE) {
            if (filterLogic.getLeftFilter().getFeatures().size() > 1) {
                return this.generateFilterNodeList(filterLogic.getLeftFilter(), online, usePitAlias);
            }
            return this.generateFilterNode(filterLogic.getLeftFilter(), online, checkForInNull, usePitAlias);
        }
        SqlNode leftNode = filterLogic.getLeftFilter() != null ? this.generateFilterNode(filterLogic.getLeftFilter(), online, checkForInNull, usePitAlias) : this.generateFilterLogicNode(filterLogic.getLeftLogic(), online, checkForInNull, usePitAlias);
        SqlNode rightNode = filterLogic.getRightFilter() != null ? this.generateFilterNode(filterLogic.getRightFilter(), online, checkForInNull, usePitAlias) : this.generateFilterLogicNode(filterLogic.getRightLogic(), online, checkForInNull, usePitAlias);
        return filterLogic.getType().operator.createCall(SqlParserPos.ZERO, new SqlNode[]{leftNode, rightNode});
    }

    public SqlNode generateFilterNode(Filter filter, boolean online) {
        return this.generateFilterNode(filter, online, true, false);
    }

    public SqlNode generateFilterNode(Filter filter, boolean online, boolean checkForInNull, boolean usePitAlias) {
        SqlNode filterValue;
        SqlNode sqlNode;
        Feature feature = filter.getFeatures().get(0);
        if (feature.getDefaultValue() == null) {
            if (feature.getFgAlias(usePitAlias) != null) {
                String featurePrefixed = feature.getName();
                if (usePitAlias && !Strings.isNullOrEmpty((String)feature.getPrefix())) {
                    featurePrefixed = feature.getPrefix() + feature.getName();
                }
                sqlNode = new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias(usePitAlias) + "`", "`" + featurePrefixed + "`"), SqlParserPos.ZERO);
            } else {
                sqlNode = new SqlIdentifier("`" + feature.getName() + "`", SqlParserPos.ZERO);
            }
        } else {
            sqlNode = this.constructorController.caseWhenDefault(feature);
        }
        Object json = null;
        if (filter.getValue().makeSqlValue() != null) {
            json = new JSONTokener(filter.getValue().makeSqlValue()).nextValue();
        }
        if (json instanceof JSONArray) {
            ArrayList<SqlNode> operandList = new ArrayList<SqlNode>();
            for (Object item : (List)new Gson().fromJson(filter.getValue().getValue(), List.class)) {
                if (item == null && checkForInNull) {
                    FilterLogic wrappedIn = new FilterLogic(SqlFilterLogic.OR, filter, new Filter(filter.getFeatures(), SqlCondition.IS, (String)null));
                    return this.generateFilterLogicNode(wrappedIn, online, false, usePitAlias);
                }
                if (item == null) continue;
                operandList.add(this.getSQLNode(filter.getFeatures().get(0).getType(), new FilterValue(item.toString())));
            }
            filterValue = new SqlNodeList(operandList, SqlParserPos.ZERO);
        } else {
            filterValue = this.getSQLNode(feature.getType(), filter.getValue());
        }
        if (Arrays.asList(SqlCondition.EQUALS, SqlCondition.IS).contains(filter.getCondition()) && filter.getValue().getValue() == null) {
            return SqlCondition.IS.operator.createCall(SqlParserPos.ZERO, new SqlNode[]{sqlNode});
        }
        return filter.getCondition().operator.createCall(SqlParserPos.ZERO, new SqlNode[]{sqlNode, filterValue});
    }

    protected SqlNode getSQLNode(String type, String value) {
        return this.getSQLNode(type, new FilterValue(value));
    }

    protected SqlNode getSQLNode(String type, FilterValue value) {
        if (value.isFeatureValue()) {
            return new SqlIdentifier(value.makeSqlValue(), SqlParserPos.ZERO);
        }
        if (value.makeSqlValue() == null) {
            return SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
        }
        if (type.equalsIgnoreCase("string")) {
            return SqlLiteral.createCharString((String)value.makeSqlValue(), (SqlParserPos)SqlParserPos.ZERO);
        }
        if (type.equalsIgnoreCase("date")) {
            return SqlLiteral.createDate((DateString)new DateString(value.makeSqlValue()), (SqlParserPos)SqlParserPos.ZERO);
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return SqlLiteral.createTimestamp((TimestampString)new TimestampString(value.makeSqlValue()), (int)3, (SqlParserPos)SqlParserPos.ZERO);
        }
        return new SqlIdentifier(value.makeSqlValue(), SqlParserPos.ZERO);
    }

    public SqlNode buildFilterNode(Query baseQuery, Query query, int i, boolean online) {
        return this.buildFilterNode(baseQuery, query, i, online, false);
    }

    public SqlNode buildFilterNode(Query baseQuery, Query query, int i, boolean online, boolean usePitAlias) {
        if (i < 0 && query.getFilter() != null) {
            return this.generateFilterLogicNode(query.getFilter(), online, true, usePitAlias);
        }
        if (i >= 0) {
            SqlNode filter = this.buildFilterNode(baseQuery, baseQuery.getJoins().get(i).getRightQuery(), i - 1, online, usePitAlias);
            if (filter != null && query.getFilter() != null) {
                return SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, new SqlNode[]{this.generateFilterLogicNode(query.getFilter(), online), filter});
            }
            if (filter != null) {
                return filter;
            }
            if (query.getFilter() != null) {
                return this.generateFilterLogicNode(query.getFilter(), online, true, usePitAlias);
            }
        }
        return null;
    }

    public SqlNode generateFilterNodeList(Filter filter, boolean online, boolean usePitAlias) {
        SqlNodeList operandList = new SqlNodeList(SqlParserPos.ZERO);
        for (Feature feature : filter.getFeatures()) {
            if (feature.getDefaultValue() == null) {
                if (feature.getFgAlias(usePitAlias) != null) {
                    operandList.add((SqlNode)new SqlIdentifier(Arrays.asList("`" + feature.getFgAlias(usePitAlias) + "`", "`" + feature.getName() + "`"), SqlParserPos.ZERO));
                    continue;
                }
                operandList.add((SqlNode)new SqlIdentifier("`" + feature.getName() + "`", SqlParserPos.ZERO));
                continue;
            }
            operandList.add(this.constructorController.caseWhenDefault(feature));
        }
        return SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, new SqlNode[]{operandList, new SqlIdentifier("?", SqlParserPos.ZERO)});
    }
}

