/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureDescriptiveStatistics;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.javatuples.Pair;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeatureDescriptiveStatisticsFacade
extends AbstractFacade<FeatureDescriptiveStatistics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureDescriptiveStatisticsFacade() {
        super(FeatureDescriptiveStatistics.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<FeatureDescriptiveStatistics> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("FeatureDescriptiveStatistics.findById", FeatureDescriptiveStatistics.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<FeatureDescriptiveStatistics> findOrphaned(Pair<Integer, Integer> range) {
        String queryString = "SELECT fds.* FROM hopsworks.feature_descriptive_statistics fds WHERE NOT EXISTS (SELECT id FROM hopsworks.feature_group_descriptive_statistics WHERE feature_descriptive_statistics_id = fds.id) AND NOT EXISTS (SELECT id FROM hopsworks.feature_view_descriptive_statistics WHERE feature_descriptive_statistics_id = fds.id) AND NOT EXISTS (SELECT id FROM hopsworks.training_dataset_descriptive_statistics WHERE feature_descriptive_statistics_id = fds.id) AND NOT EXISTS (SELECT id FROM hopsworks.test_dataset_descriptive_statistics WHERE feature_descriptive_statistics_id = fds.id) AND NOT EXISTS (SELECT id FROM hopsworks.val_dataset_descriptive_statistics WHERE feature_descriptive_statistics_id = fds.id)AND NOT EXISTS (SELECT id FROM hopsworks.feature_monitoring_result WHERE (detection_stats_id = fds.id) OR (reference_stats_id = fds.id))";
        Query q = this.em.createNativeQuery(queryString, FeatureDescriptiveStatistics.class);
        if (range != null) {
            q.setMaxResults((Integer)range.getValue1() - (Integer)range.getValue0());
            q.setFirstResult(((Integer)range.getValue0()).intValue());
        } else {
            q.setFirstResult(0);
            q.setMaxResults(Integer.MAX_VALUE);
        }
        return q.getResultList();
    }

    public int batchDelete(List<FeatureDescriptiveStatistics> fds) {
        List fdsIds = fds.stream().map(FeatureDescriptiveStatistics::getId).collect(Collectors.toList());
        TypedQuery query = this.em.createNamedQuery("FeatureDescriptiveStatistics.deleteBatch", FeatureDescriptiveStatistics.class);
        query.setParameter("fdsIds", fdsIds);
        return query.executeUpdate();
    }
}

