/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsFilters;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.FeatureViewStatistics;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeatureViewStatisticsFacade
extends AbstractFacade<FeatureViewStatistics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeatureViewStatisticsFacade() {
        super(FeatureViewStatistics.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AbstractFacade.CollectionInfo<FeatureViewStatistics> findByFeatureView(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, FeatureView featureView) {
        String queryStr = this.buildQuery("SELECT s from FeatureViewStatistics s ", filters, sorts, "s.featureView = :featureView");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from FeatureViewStatistics s ", filters, sorts, "s.featureView = :featureView");
        TypedQuery query = this.em.createQuery(queryStr, FeatureViewStatistics.class).setParameter("featureView", (Object)featureView);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureViewStatistics.class).setParameter("featureView", (Object)featureView);
        StatisticsFilters.setFilter(filters, (Query)query);
        StatisticsFilters.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo<FeatureViewStatistics> findByFeatureViewWithFeatureNames(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Set<String> featureNames, FeatureView featureView) throws FeaturestoreException {
        Object fNsParamValue;
        String fNsOperator;
        if (featureNames.size() > 1) {
            fNsOperator = "IN";
            fNsParamValue = featureNames;
        } else {
            fNsOperator = "=";
            fNsParamValue = featureNames.iterator().next();
        }
        if (limit != null) {
            return this.findByFeatureViewWithFeatureNames(offset, limit, sorts, filters, fNsOperator, fNsParamValue, featureView);
        }
        return this.findByFeatureViewWithFeatureNames(sorts, filters, fNsOperator, fNsParamValue, featureView);
    }

    private AbstractFacade.CollectionInfo<FeatureViewStatistics> findByFeatureViewWithFeatureNames(Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, String fNsOperator, Object fNsParamValue, FeatureView featureView) throws FeaturestoreException {
        String queryStr = this.buildQuery("SELECT DISTINCT s from FeatureViewStatistics s LEFT JOIN FETCH s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureView = :featureView AND fds.featureName " + fNsOperator + " :featureName");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT s.id) from FeatureViewStatistics s LEFT JOIN FETCH s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureView = :featureView AND fds.featureName " + fNsOperator + " :featureName");
        TypedQuery query = this.em.createQuery(queryStr, FeatureViewStatistics.class).setParameter("featureView", (Object)featureView).setParameter("featureName", fNsParamValue);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, FeatureViewStatistics.class).setParameter("featureView", (Object)featureView).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, (Query)query);
        StatisticsFilters.setFilter(filters, (Query)queryCount);
        long count = (Long)queryCount.getSingleResult();
        if (count == 0L) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_NOT_FOUND, Level.FINE, "Statistics for feature view id '" + featureView.getId() + "' not found. Please, try again with different filters.");
        }
        return new AbstractFacade.CollectionInfo(Long.valueOf(count), query.getResultList());
    }

    private AbstractFacade.CollectionInfo<FeatureViewStatistics> findByFeatureViewWithFeatureNames(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, String fNsOperator, Object fNsParamValue, FeatureView featureView) throws FeaturestoreException {
        String fgsQueryStr = this.buildQuery("SELECT DISTINCT s.id from FeatureViewStatistics s LEFT JOIN s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureView = :featureView AND fds.featureName " + fNsOperator + " :featureName");
        String fgsQueryCountStr = this.buildQuery("SELECT COUNT(DISTINCT s.id) from FeatureViewStatistics s LEFT JOIN s.featureDescriptiveStatistics fds ", filters, sorts, "s.featureView = :featureView AND fds.featureName " + fNsOperator + " :featureName");
        Query fgsQuery = this.em.createQuery(fgsQueryStr).setParameter("featureView", (Object)featureView).setParameter("featureName", fNsParamValue);
        Query fgsQueryCount = this.em.createQuery(fgsQueryCountStr).setParameter("featureView", (Object)featureView).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, fgsQuery);
        this.setOffsetAndLim(offset, limit, fgsQuery);
        StatisticsFilters.setFilter(filters, fgsQueryCount);
        long count = (Long)fgsQueryCount.getSingleResult();
        if (count == 0L) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_NOT_FOUND, Level.FINE, "Statistics for feature view id '" + featureView.getId() + "' not found. Please, try again with different filters.");
        }
        Set fgsIds = fgsQuery.getResultList().stream().collect(Collectors.toSet());
        String queryStr = this.buildQuery("SELECT DISTINCT s from FeatureViewStatistics s LEFT JOIN FETCH s.featureDescriptiveStatistics fds ", filters, sorts, "s.id IN :fgsIds AND fds.featureName " + fNsOperator + " :featureName");
        TypedQuery query = this.em.createQuery(queryStr, FeatureViewStatistics.class).setParameter("fgsIds", fgsIds).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, (Query)query);
        return new AbstractFacade.CollectionInfo(Long.valueOf(count), query.getResultList());
    }
}

