/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featureview.FeatureViewController;
import io.hops.hopsworks.common.featurestore.statistics.FeatureDescriptiveStatisticsDTO;
import io.hops.hopsworks.common.featurestore.statistics.SplitStatisticsDTO;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsDTO;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsFilters;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class StatisticsInputValidation {
    public void validateFeatureDescriptiveStatistics(FeatureDescriptiveStatisticsDTO fdsDto) {
        if (fdsDto.getFeatureName() == null) {
            throw new IllegalArgumentException("Feature name is missing in descriptive statistics");
        }
        if (fdsDto.getExtendedStatistics() != null) {
            try {
                new JSONObject(fdsDto.getExtendedStatistics());
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Extended statistics are not a valid json string");
            }
        }
    }

    public void validateRegisterFeatureDescriptiveStatistics(Collection<FeatureDescriptiveStatisticsDTO> fds, String content) {
        if (fds != null && content != null) {
            throw new IllegalArgumentException("Both descriptive statistics and content cannot be provided together");
        }
        Set featureNames = fds.stream().map(FeatureDescriptiveStatisticsDTO::getFeatureName).collect(Collectors.toSet());
        if (featureNames.size() != fds.size()) {
            throw new IllegalArgumentException("Feature descriptive statistics provided cannot contain two or more statistics for the same feature name");
        }
        for (FeatureDescriptiveStatisticsDTO fdsDTO : fds) {
            this.validateFeatureDescriptiveStatistics(fdsDTO);
        }
    }

    public void validateRegisterStatistics(StatisticsDTO statisticsDTO) {
        if (statisticsDTO.getFeatureDescriptiveStatistics() != null || statisticsDTO.getContent() != null) {
            if (statisticsDTO.getSplitStatistics() != null) {
                throw new IllegalArgumentException("Both descriptive statistics and split statistics cannot be provided together");
            }
            this.validateRegisterFeatureDescriptiveStatistics(statisticsDTO.getFeatureDescriptiveStatistics(), statisticsDTO.getContent());
        } else {
            if (statisticsDTO.getSplitStatistics() == null) {
                throw new IllegalArgumentException("Descriptive statistics not provided.");
            }
            for (SplitStatisticsDTO splitStats : statisticsDTO.getSplitStatistics()) {
                this.validateRegisterFeatureDescriptiveStatistics(splitStats.getFeatureDescriptiveStatistics(), splitStats.getContent());
            }
        }
    }

    private void validateCommitAndWindowTimesOccurance(Long commitTime, Long windowStartTime, Long windowEndTime) {
        if (commitTime != null && (windowStartTime != null && commitTime < windowStartTime || windowEndTime != null && commitTime < windowEndTime)) {
            throw new IllegalArgumentException("Statistics computation time cannot be lower than window times");
        }
    }

    public void validateRegisterForFeatureGroup(Featuregroup featuregroup, StatisticsDTO statisticsDTO) throws FeaturestoreException {
        this.validateRegisterStatistics(statisticsDTO);
        if (!FeaturegroupController.isTimeTravelEnabled(featuregroup)) {
            if (statisticsDTO.getWindowStartCommitTime() != null || statisticsDTO.getWindowEndCommitTime() != null) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_STATISTICS_WINDOW_TIMES, Level.FINE, "Commit window is only supported on time-travel enabled or stream feature groups");
            }
        } else if (statisticsDTO.getWindowStartCommitTime() != null && statisticsDTO.getWindowEndCommitTime() == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_STATISTICS_WINDOW_TIMES, Level.FINE, "Commit window end time is required if start time is provided");
        }
        this.validateCommitAndWindowTimesOccurance(statisticsDTO.getComputationTime(), statisticsDTO.getWindowStartCommitTime(), statisticsDTO.getWindowEndCommitTime());
    }

    public void validateRegisterForFeatureView(FeatureView featureView, StatisticsDTO statisticsDTO) throws FeaturestoreException {
        this.validateRegisterStatistics(statisticsDTO);
        Featuregroup featuregroup = FeatureViewController.getLeftFeatureGroup(featureView);
        this.validateRegisterForFeatureGroup(featuregroup, statisticsDTO);
    }

    public void validateGetForFeatureGroup(Featuregroup featuregroup, StatisticsFilters fgsFilters) throws FeaturestoreException {
        if (!FeaturegroupController.isTimeTravelEnabled(featuregroup)) {
            if (fgsFilters.getWindowStartCommitTime() != null || fgsFilters.getWindowEndCommitTime() != null) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_STATISTICS_WINDOW_TIMES, Level.FINE, "Commit window is only supported on time-travel enabled or stream feature groups");
            }
        } else if (fgsFilters.getWindowStartCommitTime() != null && fgsFilters.getWindowEndCommitTime() == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_STATISTICS_WINDOW_TIMES, Level.FINE, "Commit window end time is required if start time is provided");
        }
        this.validateCommitAndWindowTimesOccurance(fgsFilters.getComputationTime(), fgsFilters.getWindowStartCommitTime(), fgsFilters.getWindowEndCommitTime());
    }

    public void validateGetForFeatureView(FeatureView featureView, StatisticsFilters fvsFilters) throws FeaturestoreException {
        Featuregroup featuregroup = FeatureViewController.getLeftFeatureGroup(featureView);
        this.validateGetForFeatureGroup(featuregroup, fvsFilters);
    }

    public void validateRegisterForTrainingDataset(TrainingDataset trainingDataset, StatisticsDTO statisticsDTO) throws FeaturestoreException {
        this.validateRegisterStatistics(statisticsDTO);
        if (statisticsDTO.getWindowStartCommitTime() != null || statisticsDTO.getWindowEndCommitTime() != null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INVALID_STATISTICS_WINDOW_TIMES, Level.FINE, "Commit time window not supported for training dataset statistics");
        }
    }

    public void validateStatisticsFiltersForFeatureGroup(Set<AbstractFacade.FilterBy> filters) {
        this.validateStatisticsFilters(filters, "Feature Group", true, true, false);
    }

    public void validateStatisticsFiltersForFeatureView(Set<AbstractFacade.FilterBy> filters) {
        this.validateStatisticsFilters(filters, "Feature View", true, true, false);
    }

    public void validateStatisticsFiltersForTrainingDataset(Set<AbstractFacade.FilterBy> filters) {
        this.validateStatisticsFilters(filters, "Training Dataset", false, false, true);
    }

    public void validateStatisticsFilters(Set<AbstractFacade.FilterBy> filters, String statisticsType, boolean windowCommitTimes, boolean rowPercentage, boolean beforeTransformation) {
        boolean computationTimeLt = false;
        boolean computationTimeEq = false;
        boolean computationTimeGt = false;
        boolean windowStartCT = false;
        boolean windowEndCT = false;
        String overlappingErrMsg = "Overlapping filters are not supported";
        String notSupportedErrMsg = "Filter '%s' not supported for %s statistics";
        if (filters != null) {
            for (AbstractFacade.FilterBy filter : filters) {
                if (filter.getValue().startsWith(StatisticsFilters.Filters.COMPUTATION_TIME_LT.getValue())) {
                    if (computationTimeLt || computationTimeEq) {
                        throw new IllegalArgumentException(overlappingErrMsg);
                    }
                    computationTimeLt = true;
                    continue;
                }
                if (filter.getValue().startsWith(StatisticsFilters.Filters.COMPUTATION_TIME_LTOEQ.getValue())) {
                    if (computationTimeLt) {
                        throw new IllegalArgumentException(overlappingErrMsg);
                    }
                    computationTimeLt = true;
                    continue;
                }
                if (filter.getValue().startsWith(StatisticsFilters.Filters.COMPUTATION_TIME_GT.getValue())) {
                    if (computationTimeGt || computationTimeEq) {
                        throw new IllegalArgumentException(overlappingErrMsg);
                    }
                    computationTimeGt = true;
                    continue;
                }
                if (filter.getValue().startsWith(StatisticsFilters.Filters.COMPUTATION_TIME_EQ.getValue())) {
                    if (computationTimeEq || computationTimeLt || computationTimeGt) {
                        throw new IllegalArgumentException(overlappingErrMsg);
                    }
                    computationTimeEq = true;
                    continue;
                }
                if (filter.getValue().startsWith(StatisticsFilters.Filters.WINDOW_START_COMMIT_TIME_GTOEQ.getValue()) || filter.getValue().startsWith(StatisticsFilters.Filters.WINDOW_START_COMMIT_TIME_EQ.getValue())) {
                    if (!windowCommitTimes) {
                        throw new IllegalArgumentException(String.format(notSupportedErrMsg, filter.getValue(), statisticsType));
                    }
                    if (windowStartCT) {
                        throw new IllegalArgumentException(overlappingErrMsg);
                    }
                    windowStartCT = true;
                    continue;
                }
                if (filter.getValue().startsWith(StatisticsFilters.Filters.WINDOW_END_COMMIT_TIME_LTOEQ.getValue()) || filter.getValue().startsWith(StatisticsFilters.Filters.WINDOW_END_COMMIT_TIME_EQ.getValue())) {
                    if (!windowCommitTimes) {
                        throw new IllegalArgumentException(String.format(notSupportedErrMsg, filter.getValue(), statisticsType));
                    }
                    if (windowEndCT) {
                        throw new IllegalArgumentException(overlappingErrMsg);
                    }
                    windowEndCT = true;
                    continue;
                }
                if (!rowPercentage && filter.getValue().startsWith(StatisticsFilters.Filters.ROW_PERCENTAGE_EQ.getValue())) {
                    throw new IllegalArgumentException(String.format(notSupportedErrMsg, filter.getValue(), statisticsType));
                }
                if (beforeTransformation || !filter.getValue().startsWith(StatisticsFilters.Filters.BEFORE_TRANSFORMATION_EQ.getValue())) continue;
                throw new IllegalArgumentException(String.format(notSupportedErrMsg, filter.getValue(), statisticsType));
            }
        }
    }
}

