/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.statistics;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsFilters;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.TrainingDatasetStatistics;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class TrainingDatasetStatisticsFacade
extends AbstractFacade<TrainingDatasetStatistics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public TrainingDatasetStatisticsFacade() {
        super(TrainingDatasetStatistics.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AbstractFacade.CollectionInfo<TrainingDatasetStatistics> findByTrainingDataset(Set<? extends AbstractFacade.FilterBy> filters, TrainingDataset trainingDataset) {
        String queryStr = this.buildQuery("SELECT s from TrainingDatasetStatistics s ", filters, null, "s.trainingDataset = :trainingDataset");
        String queryCountStr = this.buildQuery("SELECT COUNT(s.id) from TrainingDatasetStatistics s ", filters, null, "s.trainingDataset = :trainingDataset");
        TypedQuery query = this.em.createQuery(queryStr, TrainingDatasetStatistics.class).setParameter("trainingDataset", (Object)trainingDataset);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, TrainingDatasetStatistics.class).setParameter("trainingDataset", (Object)trainingDataset);
        StatisticsFilters.setFilter(filters, (Query)query);
        StatisticsFilters.setFilter(filters, (Query)queryCount);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    public AbstractFacade.CollectionInfo<TrainingDatasetStatistics> findByTrainingDatasetWithFeatureNames(Set<? extends AbstractFacade.FilterBy> filters, Set<String> featureNames, TrainingDataset trainingDataset) throws FeaturestoreException {
        Object fNsParamValue;
        String fNsOperator;
        if (featureNames.size() > 1) {
            fNsOperator = "IN";
            fNsParamValue = featureNames;
        } else {
            fNsOperator = "=";
            fNsParamValue = featureNames.iterator().next();
        }
        List<TrainingDatasetStatistics> tdss = this.findByTrainingDatasetSplitWithFeatureNames(filters, fNsOperator, fNsParamValue, "trainFeatureDescriptiveStatistics", trainingDataset);
        if (tdss.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STATISTICS_NOT_FOUND, Level.FINE, "Statistics for training dataset id '" + trainingDataset.getId() + "' not found. Please, try again with different filters.");
        }
        TrainingDatasetStatistics tds = tdss.get(0);
        this.detach(tds);
        Optional<AbstractFacade.FilterBy> forTransFilter = filters.stream().filter(f -> f.getValue().startsWith(StatisticsFilters.Filters.BEFORE_TRANSFORMATION_EQ.getValue())).findAny();
        if (forTransFilter.isPresent() && !Boolean.parseBoolean(forTransFilter.get().getParam())) {
            int numSplits = trainingDataset.getSplits().size();
            if (numSplits > 1) {
                List<TrainingDatasetStatistics> testFDS = this.findByTrainingDatasetSplitWithFeatureNames(filters, fNsOperator, fNsParamValue, "testFeatureDescriptiveStatistics", trainingDataset);
                tds.setTestFeatureDescriptiveStatistics(testFDS.get(0).getTestFeatureDescriptiveStatistics());
            }
            if (numSplits > 2) {
                List<TrainingDatasetStatistics> valFDS = this.findByTrainingDatasetSplitWithFeatureNames(filters, fNsOperator, fNsParamValue, "valFeatureDescriptiveStatistics", trainingDataset);
                tds.setValFeatureDescriptiveStatistics(valFDS.get(0).getValFeatureDescriptiveStatistics());
            }
        }
        return new AbstractFacade.CollectionInfo(Long.valueOf(1L), Collections.singletonList(tds));
    }

    private List<TrainingDatasetStatistics> findByTrainingDatasetSplitWithFeatureNames(Set<? extends AbstractFacade.FilterBy> filters, String fNsOperator, Object fNsParamValue, String splitCollectionName, TrainingDataset trainingDataset) {
        String queryStr = this.buildQuery("SELECT DISTINCT s from TrainingDatasetStatistics s LEFT JOIN FETCH s." + splitCollectionName + " fds ", filters, null, "s.trainingDataset = :trainingDataset AND fds.featureName " + fNsOperator + " :featureName");
        TypedQuery query = this.em.createQuery(queryStr, TrainingDatasetStatistics.class).setParameter("trainingDataset", (Object)trainingDataset).setParameter("featureName", fNsParamValue);
        StatisticsFilters.setFilter(filters, (Query)query);
        return query.getResultList();
    }
}

