/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.jdbc;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretPlaintext;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.OptionDTO;
import io.hops.hopsworks.common.featurestore.online.OnlineFeaturestoreController;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.jdbc.FeaturestoreJdbcConnectorDTO;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnector;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.HiveTags;
import io.hops.hopsworks.servicediscovery.tags.MysqlTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreJdbcConnectorController {
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private SecretsController secretsController;
    @EJB
    private OnlineFeaturestoreController onlineFeaturestoreController;
    @EJB
    private StorageConnectorUtil storageConnectorUtil;
    @EJB
    private SecretsFacade secretsFacade;
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreJdbcConnectorController.class.getName());

    public FeaturestoreJdbcConnector createFeaturestoreJdbcConnector(Users user, Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException, ProjectException, UserException {
        return this.createOrUpdateJdbcConnector(user, featurestore, featurestoreJdbcConnectorDTO, new FeaturestoreJdbcConnector());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class})
    public FeaturestoreJdbcConnector updateFeaturestoreJdbcConnector(Users user, Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector) throws FeaturestoreException, ProjectException, UserException {
        return this.createOrUpdateJdbcConnector(user, featurestore, featurestoreJdbcConnectorDTO, featurestoreJdbcConnector);
    }

    private void verifyJdbcConnectorConnectionString(String connectionString) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)connectionString) || connectionString.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_STRING, Level.FINE, ", the JDBC connection string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyJdbcConnectorArguments(String arguments) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)arguments) && arguments.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_JDBC_CONNECTION_ARGUMENTS, Level.FINE, "JDBC connection arguments should not exceed: 2000 characters");
        }
    }

    public FeaturestoreJdbcConnectorDTO getJdbcConnectorDTO(Users user, Project project, FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO = new FeaturestoreJdbcConnectorDTO(featurestoreConnector);
        Secret secret = featurestoreConnector.getJdbcConnector().getPasswordSecret();
        SecretPlaintext plaintSecret = null;
        if (secret != null) {
            try {
                plaintSecret = this.secretsController.get(user, secret.getId().getName());
            }
            catch (UserException e) {
                LOGGER.log(Level.SEVERE, String.format("Could not get plain secret for jdbc connector password for project: %s, user: %s", project.getName(), user.getEmail()), e);
            }
        }
        featurestoreJdbcConnectorDTO.setArguments(this.storageConnectorUtil.toOptions(featurestoreConnector.getJdbcConnector().getArguments()));
        if (featurestoreJdbcConnectorDTO.getName().equals(this.onlineFeaturestoreController.onlineDbUsername(project, user) + "_onlinefeaturestore")) {
            this.setPasswordPlainTextForOnlineJdbcConnector(user, featurestoreJdbcConnectorDTO, project);
        } else if (plaintSecret != null) {
            this.storageConnectorUtil.replaceToPlainText(featurestoreJdbcConnectorDTO.getArguments(), plaintSecret.getPlaintext());
            featurestoreJdbcConnectorDTO.setConnectionString(this.storageConnectorUtil.replaceToPlainText(featurestoreJdbcConnectorDTO.getConnectionString(), plaintSecret.getPlaintext()));
        }
        this.replaceOnlineFsConnectorUrl(featurestoreJdbcConnectorDTO);
        this.replaceOfflineFsConnectorUrl(featurestoreJdbcConnectorDTO);
        featurestoreJdbcConnectorDTO.setDriverPath(featurestoreConnector.getJdbcConnector().getDriverPath());
        return featurestoreJdbcConnectorDTO;
    }

    private String getConnectorPlainPasswordFromSecret(Users user, Project project) {
        String secretName = this.onlineFeaturestoreController.onlineDbUsername(project, user);
        try {
            SecretPlaintext plaintext = this.secretsController.get(user, secretName);
            return plaintext.getPlaintext();
        }
        catch (UserException e) {
            LOGGER.log(Level.SEVERE, String.format("Could not get the online jdbc connector password for project: %s, user: %s", project.getName(), user.getEmail()));
            return null;
        }
    }

    private void setPasswordPlainTextForOnlineJdbcConnector(Users user, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, Project project) {
        String connectorPassword = this.getConnectorPlainPasswordFromSecret(user, project);
        this.storageConnectorUtil.replaceToPlainText(featurestoreJdbcConnectorDTO.getArguments(), connectorPassword);
    }

    private void replaceOnlineFsConnectorUrl(FeaturestoreJdbcConnectorDTO jdbcConnectorDTO) throws FeaturestoreException {
        String connectionString = "";
        try {
            connectionString = jdbcConnectorDTO.getConnectionString().replace(this.serviceDiscoveryController.constructServiceFQDN(HopsworksService.MYSQL.getNameWithTag((ServiceTags)MysqlTags.onlinefs)), this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.MYSQL.getNameWithTag((ServiceTags)MysqlTags.onlinefs)).getAddress());
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error resolving MySQL DNS name", e.getMessage(), (Throwable)e);
        }
        jdbcConnectorDTO.setConnectionString(connectionString);
    }

    private void replaceOfflineFsConnectorUrl(FeaturestoreJdbcConnectorDTO jdbcConnectorDTO) throws FeaturestoreException {
        String connectionString = "";
        try {
            connectionString = jdbcConnectorDTO.getConnectionString().replace(this.serviceDiscoveryController.constructServiceFQDN(HopsworksService.HIVE.getNameWithTag((ServiceTags)HiveTags.hiveserver2_tls)), this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.HIVE.getNameWithTag((ServiceTags)HiveTags.hiveserver2_tls)).getAddress());
        }
        catch (ServiceDiscoveryException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.STORAGE_CONNECTOR_GET_ERROR, Level.SEVERE, "Error resolving Hive DNS name", e.getMessage(), (Throwable)e);
        }
        jdbcConnectorDTO.setConnectionString(connectionString);
    }

    private FeaturestoreJdbcConnector createOrUpdateJdbcConnector(Users user, Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector) throws FeaturestoreException, ProjectException, UserException {
        List<OptionDTO> arguments = this.validationDTO(featurestoreJdbcConnectorDTO);
        String password = this.getPassword(featurestoreJdbcConnectorDTO.getConnectionString(), featurestoreJdbcConnectorDTO.getArguments());
        this.setPasswordReplacedFields(featurestoreJdbcConnectorDTO, featurestoreJdbcConnector, password, arguments);
        this.createOrUpdateSecret(user, featurestore, featurestoreJdbcConnectorDTO, featurestoreJdbcConnector, password, featurestoreJdbcConnector.getPasswordSecret());
        if (!Strings.isNullOrEmpty((String)featurestoreJdbcConnectorDTO.getDriverPath())) {
            featurestoreJdbcConnector.setDriverPath(featurestoreJdbcConnectorDTO.getDriverPath());
        }
        return featurestoreJdbcConnector;
    }

    public List<OptionDTO> validationDTO(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO) throws FeaturestoreException {
        this.verifyJdbcConnectorConnectionString(featurestoreJdbcConnectorDTO.getConnectionString());
        List<OptionDTO> arguments = featurestoreJdbcConnectorDTO.getArguments();
        String argumentsString = this.storageConnectorUtil.fromOptions(arguments);
        this.verifyJdbcConnectorArguments(argumentsString);
        return arguments;
    }

    private void setPasswordReplacedFields(FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector, String password, List<OptionDTO> arguments) {
        featurestoreJdbcConnector.setConnectionString(this.storageConnectorUtil.replaceToPasswordTemplate(featurestoreJdbcConnectorDTO.getConnectionString(), password));
        featurestoreJdbcConnector.setArguments(this.storageConnectorUtil.replaceToPasswordTemplate(arguments));
    }

    private void createOrUpdateSecret(Users user, Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector, String password, Secret currentSecret) throws ProjectException, UserException {
        if (!Strings.isNullOrEmpty((String)password)) {
            this.setSecret(user, featurestore, featurestoreJdbcConnectorDTO, featurestoreJdbcConnector, password, currentSecret);
        } else {
            featurestoreJdbcConnector.setPasswordSecret(null);
            if (currentSecret != null) {
                this.secretsFacade.deleteSecret(currentSecret.getId());
            }
        }
    }

    private void setSecret(Users user, Featurestore featurestore, FeaturestoreJdbcConnectorDTO featurestoreJdbcConnectorDTO, FeaturestoreJdbcConnector featurestoreJdbcConnector, String password, Secret currentSecret) throws ProjectException, UserException {
        String secretName = this.storageConnectorUtil.createSecretName(featurestore.getId(), featurestoreJdbcConnectorDTO.getName(), featurestoreJdbcConnectorDTO.getStorageConnectorType());
        Secret secret = this.storageConnectorUtil.updateProjectSecret(user, currentSecret, secretName, featurestore, password);
        featurestoreJdbcConnector.setPasswordSecret(secret);
    }

    private String getPassword(String connectionUrl, List<OptionDTO> arguments) {
        String password = null;
        if (connectionUrl.contains("password")) {
            password = this.storageConnectorUtil.fetchPasswordFromJdbcUrl(connectionUrl);
        } else if (arguments != null) {
            password = arguments.stream().filter(argument -> argument.getName().equals("password")).findFirst().map(OptionDTO::getValue).orElse(null);
        }
        return password;
    }
}

