/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.trainingdatasets;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.hops.hopsworks.common.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.featurestore.feature.TrainingDatasetFeatureDTO;
import io.hops.hopsworks.common.featurestore.keyword.KeywordDTO;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogicDTO;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsConfigDTO;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.trainingdatasets.DateAdapter;
import io.hops.hopsworks.common.featurestore.trainingdatasets.split.TrainingDatasetSplitDTO;
import io.hops.hopsworks.common.tags.TagsDTO;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.split.SplitType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="trainingDatasetDTO")
public class TrainingDatasetDTO
extends FeaturestoreEntityDTO<TrainingDatasetDTO> {
    private String dataFormat;
    private Boolean coalesce;
    private TrainingDatasetType trainingDatasetType;
    private List<TrainingDatasetSplitDTO> splits = new ArrayList<TrainingDatasetSplitDTO>();
    private Long seed = null;
    private String trainSplit = null;
    private FeaturestoreStorageConnectorDTO storageConnector;
    private QueryDTO queryDTO;
    private Boolean fromQuery;
    private List<TrainingDatasetFeatureDTO> features;
    private FilterLogicDTO extraFilter;
    private Double sampleRatio;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date eventStartTime;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date eventEndTime;
    private KeywordDTO keywords;
    private TagsDTO tags;
    private Boolean dataAvailable;

    public TrainingDatasetDTO() {
    }

    public TrainingDatasetDTO(TrainingDataset trainingDataset) {
        super(trainingDataset.getFeaturestore().getId(), trainingDataset.getName(), trainingDataset.getCreated(), trainingDataset.getCreator(), trainingDataset.getVersion(), trainingDataset.getId(), new StatisticsConfigDTO(trainingDataset.getStatisticsConfig()));
        this.setDescription(trainingDataset.getDescription());
        this.dataFormat = trainingDataset.getDataFormat();
        this.coalesce = trainingDataset.getCoalesce();
        this.trainingDatasetType = trainingDataset.getTrainingDatasetType();
        this.splits = trainingDataset.getSplits().stream().map(split -> {
            if (SplitType.TIME_SERIES_SPLIT.equals((Object)split.getSplitType())) {
                return new TrainingDatasetSplitDTO(split.getName(), split.getStartTime(), split.getEndTime());
            }
            return new TrainingDatasetSplitDTO(split.getName(), split.getPercentage());
        }).collect(Collectors.toList());
        this.seed = trainingDataset.getSeed();
        this.fromQuery = trainingDataset.isQuery();
        this.trainSplit = trainingDataset.getTrainSplit();
        this.eventStartTime = trainingDataset.getStartTime();
        this.eventEndTime = trainingDataset.getEndTime();
        this.sampleRatio = trainingDataset.getSampleRatio();
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Boolean getCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(Boolean coalesce) {
        this.coalesce = coalesce;
    }

    public FeaturestoreStorageConnectorDTO getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(FeaturestoreStorageConnectorDTO storageConnector) {
        this.storageConnector = storageConnector;
    }

    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    public List<TrainingDatasetSplitDTO> getSplits() {
        return this.splits;
    }

    public void setSplits(List<TrainingDatasetSplitDTO> splits) {
        this.splits = splits;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public QueryDTO getQueryDTO() {
        return this.queryDTO;
    }

    public void setQueryDTO(QueryDTO queryDTO) {
        this.queryDTO = queryDTO;
    }

    public List<TrainingDatasetFeatureDTO> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeatureDTO> features) {
        this.features = features;
    }

    public Boolean getFromQuery() {
        return this.fromQuery;
    }

    public void setFromQuery(Boolean fromQuery) {
        this.fromQuery = fromQuery;
    }

    public String getTrainSplit() {
        return this.trainSplit;
    }

    public void setTrainSplit(String trainSplit) {
        this.trainSplit = trainSplit;
    }

    public Double getSampleRatio() {
        return this.sampleRatio;
    }

    public void setSampleRatio(Double sampleRatio) {
        this.sampleRatio = sampleRatio;
    }

    public Date getEventStartTime() {
        return this.eventStartTime;
    }

    public void setEventStartTime(Date eventStartTime) {
        this.eventStartTime = eventStartTime;
    }

    public Date getEventEndTime() {
        return this.eventEndTime;
    }

    public void setEventEndTime(Date eventEndTime) {
        this.eventEndTime = eventEndTime;
    }

    public KeywordDTO getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordDTO keywords) {
        this.keywords = keywords;
    }

    public TagsDTO getTags() {
        return this.tags;
    }

    public void setTags(TagsDTO tags) {
        this.tags = tags;
    }

    public Boolean isDataAvailable() {
        return this.dataAvailable;
    }

    public void setDataAvailable(Boolean dataAvailable) {
        this.dataAvailable = dataAvailable;
    }

    public FilterLogicDTO getExtraFilter() {
        return this.extraFilter;
    }

    public void setExtraFilter(FilterLogicDTO extraFilter) {
        this.extraFilter = extraFilter;
    }

    @Override
    public String toString() {
        return "TrainingDatasetDTO{dataFormat='" + this.dataFormat + '\'' + ", trainingDatasetType=" + this.trainingDatasetType + ", splits=" + this.splits + ", seed=" + this.seed + ", trainSplit=" + this.trainSplit + '}';
    }
}

