/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs.xattrs;

import io.hops.hopsworks.common.dataset.util.DatasetPath;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.MetadataException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RemoteException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

@Stateless(name="XAttrsController")
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class XAttrsController {
    public static final String XATTR_USER_NAMESPACE = "user.";
    public static final String XATTR_PROV_NAMESPACE = "provenance.";
    @EJB
    private InodeController inodeController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService dfs;

    public boolean addXAttr(Users user, DatasetPath path, String name, String metaObj) throws DatasetException, MetadataException {
        return this.addXAttr(path.getAccessProject(), user, path.getFullPath().toString(), name, metaObj);
    }

    public boolean addXAttr(Project project, Users user, String inodePath, String name, String metaObj) throws DatasetException, MetadataException {
        if (name == null || name.isEmpty()) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        JSONObject metaJSON = null;
        Object json = new JSONTokener(metaObj).nextValue();
        if (json instanceof JSONObject) {
            metaJSON = (JSONObject)json;
        } else if (json instanceof JSONArray) {
            metaJSON = new JSONObject();
            metaJSON.put(name, (Object)json.toString());
        }
        if (!metaJSON.has(name)) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        String metadata = metaJSON.getString(name);
        boolean created = this.getXAttr(project, user, inodePath, XATTR_USER_NAMESPACE, name) == null;
        this.addXAttrInt(project, user, inodePath, name, metadata);
        return created;
    }

    public void addStrXAttr(String path, String name, String value, DistributedFileSystemOps udfso) throws MetadataException {
        if (name == null || name.isEmpty()) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        this.addXAttrInt(udfso, path, XATTR_USER_NAMESPACE, name, value.getBytes(Charsets.UTF_8));
    }

    public String getXAttr(Users user, DatasetPath path, String name) throws DatasetException, MetadataException {
        return this.getXAttr(path.getAccessProject(), user, path.getFullPath().toString(), name);
    }

    public String getXAttr(Project project, Users user, String inodePath, String name) throws DatasetException, MetadataException {
        return this.getXAttr(project, user, inodePath, XATTR_USER_NAMESPACE, name);
    }

    public String getXAttr(String path, String name, DistributedFileSystemOps udfso) throws MetadataException {
        return this.getXAttr(path, XATTR_USER_NAMESPACE, name, udfso);
    }

    public Map<String, String> getXAttrs(String path, DistributedFileSystemOps udfso) throws MetadataException {
        return this.getXAttrsInt(path, udfso);
    }

    public boolean removeXAttr(Users user, DatasetPath path, String name) throws MetadataException, DatasetException {
        return this.removeXAttr(path.getAccessProject(), user, path.getFullPath().toString(), name);
    }

    public boolean removeXAttr(Project project, Users user, String inodePath, String name) throws MetadataException, DatasetException {
        boolean found;
        if (name == null || name.isEmpty()) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        boolean bl = found = this.getXAttr(project, user, inodePath, XATTR_USER_NAMESPACE, name) != null;
        if (found) {
            this.removeXAttrInt(project, user, inodePath, name);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXAttrInt(Project project, Users user, String inodePath, String name, String metadataJson) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            this.addXAttrInt(udfso, path, XATTR_USER_NAMESPACE, name, metadataJson.getBytes(Charsets.UTF_8));
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXAttrInt(Project project, Users user, String inodePath, String name) throws MetadataException, DatasetException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            this.removeXAttrInt(udfso, path, XATTR_USER_NAMESPACE, name);
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    private String getXAttr(String path, String namespace, String name, DistributedFileSystemOps udfso) throws MetadataException {
        byte[] value = this.getXAttrInt(udfso, path, namespace, name);
        if (value != null) {
            return new String(value, Charsets.UTF_8);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXAttr(Project project, Users user, String inodePath, String namespace, String name) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            String string = this.getXAttr(path, namespace, name, udfso);
            return string;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXAttrAsSuperUser(String inodePath, String namespace, String name) throws MetadataException, DatasetException {
        String path = this.validatePath(inodePath);
        DistributedFileSystemOps dfso = this.dfs.getDfsOps();
        try {
            String string = this.getXAttr(path, namespace, name, dfso);
            return string;
        }
        finally {
            if (dfso != null) {
                this.dfs.closeDfsClient(dfso);
            }
        }
    }

    private byte[] getXAttrInt(DistributedFileSystemOps udfso, String path, String namespace, String name) throws MetadataException {
        try {
            return udfso.getXAttr(new Path(path), this.getXAttrName(namespace, name));
        }
        catch (RemoteException e) {
            if (e.getClassName().equals("io.hops.exception.StorageException") && e.getMessage().startsWith("com.mysql.clusterj.ClusterJUserException: Data length")) {
                throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED, Level.FINE, (Throwable)e);
            }
            if (e.getClassName().equals("java.io.IOException") && e.getMessage().startsWith("At least one of the attributes provided was not found.")) {
                return null;
            }
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> getXAttrsInt(String path, DistributedFileSystemOps udfso) throws MetadataException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Map<String, byte[]> attrs = udfso.getXAttrs(new Path(path));
            for (Map.Entry<String, byte[]> e : attrs.entrySet()) {
                if (e.getValue() == null || !e.getKey().startsWith(XATTR_USER_NAMESPACE)) continue;
                result.put(e.getKey().split(XATTR_USER_NAMESPACE)[1], new String(e.getValue(), Charsets.UTF_8));
            }
            return result;
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
    }

    private void addXAttrInt(DistributedFileSystemOps udfso, String path, String namespace, String name, byte[] value) throws MetadataException {
        try {
            udfso.setXAttr(new Path(path), this.getXAttrName(namespace, name), value);
        }
        catch (RemoteException e) {
            if (e.getClassName().equals("org.apache.hadoop.HadoopIllegalArgumentException") && e.getMessage().startsWith("The XAttr value is too big.")) {
                throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED, Level.FINE, (Throwable)e);
            }
            if (e.getClassName().equals("java.io.IOException") && e.getMessage().startsWith("Cannot add additional XAttr to inode, would exceed limit")) {
                throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MAX_SIZE_EXCEEDED, Level.FINE, (Throwable)e);
            }
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
    }

    private void removeXAttrInt(DistributedFileSystemOps udfso, String path, String namespace, String name) throws MetadataException {
        try {
            udfso.removeXAttr(new Path(path), this.getXAttrName(namespace, name));
        }
        catch (IOException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
    }

    private String validatePath(String path) throws MetadataException, DatasetException {
        String inodePath = path;
        try {
            inodePath = Utils.prepPath(path);
        }
        catch (UnsupportedEncodingException e) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_ERROR, Level.SEVERE, path, e.getMessage(), (Throwable)e);
        }
        if (!this.inodeController.existsPath(inodePath)) {
            throw new DatasetException(RESTCodes.DatasetErrorCode.INODE_NOT_FOUND, Level.FINE, "file " + inodePath + "doesn't exist");
        }
        return inodePath;
    }

    private DistributedFileSystemOps getDFS(Project project, Users user) {
        String hdfsUserName = this.hdfsUsersController.getHdfsUserName(project, user);
        return this.dfs.getDfsOps(hdfsUserName);
    }

    private String getXAttrName(String namespace, String name) {
        return namespace + name;
    }

    public byte[] getProvXAttr(DistributedFileSystemOps udfso, String inodePath, String name) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        return this.getXAttrInt(udfso, path, XATTR_PROV_NAMESPACE, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upsertProvXAttr(Project project, Users user, String inodePath, String name, byte[] value) throws MetadataException, DatasetException {
        DistributedFileSystemOps udfso = this.getDFS(project, user);
        try {
            boolean bl = this.upsertProvXAttr(udfso, inodePath, name, value);
            return bl;
        }
        finally {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
        }
    }

    public boolean upsertProvXAttr(DistributedFileSystemOps udfso, String inodePath, String name, byte[] value) throws MetadataException, DatasetException {
        if (name == null || name.isEmpty()) {
            throw new MetadataException(RESTCodes.MetadataErrorCode.METADATA_MISSING_FIELD, Level.FINE);
        }
        String path = this.validatePath(inodePath);
        boolean hasPrevious = this.getXAttrInt(udfso, path, XATTR_PROV_NAMESPACE, name) != null;
        this.addXAttrInt(udfso, path, XATTR_PROV_NAMESPACE, name, value);
        return hasPrevious;
    }

    public void removeProvXAttr(DistributedFileSystemOps udfso, String inodePath, String name) throws DatasetException, MetadataException {
        String path = this.validatePath(inodePath);
        this.removeXAttrInt(udfso, path, XATTR_PROV_NAMESPACE, name);
    }
}

