/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.integrations.LocalhostStereotype;
import io.hops.hopsworks.common.jupyter.NoteBookConverter;
import io.hops.hopsworks.common.jupyter.NotebookConversion;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.system.job.SystemJobStatus;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.ProjectUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.codec.digest.DigestUtils;

@Stateless
@LocalhostStereotype
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class LocalNoteBookConverter
implements NoteBookConverter {
    private static final Logger LOGGER = Logger.getLogger(LocalNoteBookConverter.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private ProjectUtils projectUtils;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private OSProcessExecutor osProcessExecutor;

    @Override
    public SystemJobStatus convertIPythonNotebook(Project project, Users user, String notebookPath, String pyPath, NotebookConversion notebookConversion) throws ServiceException {
        File baseDir = new File(this.settings.getStagingDir() + "/" + "ipython_conversions/");
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        File conversionDir = new File(baseDir, DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt())));
        conversionDir.mkdir();
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        try {
            String prog = this.settings.getSudoersDir() + "/convert-ipython-notebook.sh";
            ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand(notebookPath).addCommand(hdfsUser).addCommand(this.settings.getAnacondaProjectDir()).addCommand(pyPath).addCommand(conversionDir.getAbsolutePath()).addCommand(notebookConversion.name()).addCommand(this.projectUtils.getFullDockerImageName(project, true)).setWaitTimeout(120L, TimeUnit.SECONDS).redirectErrorStream(true).build();
            LOGGER.log(Level.FINE, processDescriptor.toString());
            this.certificateMaterializer.materializeCertificatesLocalCustomDir(user.getUsername(), project.getName(), conversionDir.getAbsolutePath());
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited() || processResult.getExitCode() != 0) {
                LOGGER.log(Level.WARNING, "error code: " + processResult.getExitCode(), "Failed to convert " + notebookPath + "\nstderr: " + processResult.getStderr() + "\nstdout: " + processResult.getStdout());
                throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, "Failed to convert ipython notebook to " + (Object)((Object)notebookConversion) + " file", "Failed to convert " + notebookPath + "\nstderr: " + processResult.getStderr() + "\nstdout: " + processResult.getStdout());
            }
            String stdOut = processResult.getStdout();
            SystemJobStatus status = new SystemJobStatus(0);
            status.setLog(stdOut);
            if (notebookConversion.equals((Object)NotebookConversion.HTML)) {
                status.setLog(this.getHtmlFromLog(stdOut));
            }
            SystemJobStatus systemJobStatus = status;
            return systemJobStatus;
        }
        catch (ServiceDiscoveryException | IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, null, ex.getMessage(), ex);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocalCustomDir(user.getUsername(), project.getName(), conversionDir.getAbsolutePath());
        }
    }
}

