/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.common.util.PayaraClusterManager;
import io.hops.hopsworks.jwt.JWTController;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Startup
@Singleton
public class OneTimeJWTRotation {
    private static final Logger LOGGER = Logger.getLogger(OneTimeJWTRotation.class.getName());
    @EJB
    private JWTController jWTController;
    @EJB
    private PayaraClusterManager payaraClusterManager;
    @Resource
    TimerService timerService;
    private Timer timer;

    @PostConstruct
    public void init() {
        long intervalDuration = TimeUnit.HOURS.toMillis(24L);
        this.timer = this.timerService.createIntervalTimer(0L, intervalDuration, new TimerConfig((Serializable)((Object)"Mark old one-time JWT signing key"), false));
    }

    @PreDestroy
    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Timeout
    public void rotateOneTimeJWTSigningKey(Timer timer) {
        if (!this.payaraClusterManager.amIThePrimary()) {
            LOGGER.log(Level.INFO, "I am not the Primary or Active region. Skip rotating one-time JWT signing key");
            return;
        }
        String timerInfo = (String)((Object)timer.getInfo());
        if (timerInfo.startsWith("Mark")) {
            LOGGER.log(Level.INFO, "Rotating one-time JWT signing key");
            boolean marked = this.jWTController.markOldSigningKeys();
            if (marked) {
                LOGGER.log(Level.INFO, "Marked old one-time JWT signing key, scheduling Sweeper");
                long duration = 240000L;
                TimerConfig config = new TimerConfig();
                config.setInfo((Serializable)((Object)"Sweep old one-time JWT signing key"));
                config.setPersistent(false);
                this.timerService.createSingleActionTimer(duration, config);
            }
        } else if (timerInfo.startsWith("Sweep")) {
            LOGGER.log(Level.INFO, "Sweeping old one-time JWT signing key");
            try {
                this.jWTController.removeMarkedKeys();
                LOGGER.log(Level.INFO, "Deleted old one-time JWT signing key");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to delete old one-time JWT signing key", e);
            }
        }
    }
}

