/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.kafka;

import io.hops.hopsworks.common.dao.kafka.HopsKafkaAdminClient;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.StringUtils;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class KafkaBrokers {
    @EJB
    protected HopsKafkaAdminClient hopsKafkaAdminClient;
    private final Set<String> kafkaBrokers = new HashSet<String>();

    @PostConstruct
    @Lock(value=LockType.WRITE)
    public void setBrokerEndpoints() {
        this.kafkaBrokers.clear();
        this.kafkaBrokers.addAll(this.hopsKafkaAdminClient.getBrokerEndpoints());
    }

    @Lock(value=LockType.READ)
    public List<String> getBrokerEndpoints(BrokerProtocol protocol) {
        return this.kafkaBrokers.stream().filter(bi -> bi.startsWith(protocol.toString())).map(bi -> bi.replaceAll((Object)((Object)protocol) + ".*://", "")).collect(Collectors.toList());
    }

    @Lock(value=LockType.READ)
    public String getBrokerEndpointsString(BrokerProtocol protocol) {
        List<String> kafkaProtocolBrokers = this.getBrokerEndpoints(protocol);
        if (!kafkaProtocolBrokers.isEmpty()) {
            return StringUtils.join(kafkaProtocolBrokers, (String)",");
        }
        return null;
    }

    public static enum BrokerProtocol {
        INTERNAL,
        EXTERNAL;

    }
}

