/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.models;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.models.Model;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class ModelFacade
extends AbstractFacade<Model> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    private static final Logger LOGGER = Logger.getLogger(ModelFacade.class.getName());

    public ModelFacade() {
        super(Model.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Model put(Project project, String name) {
        if (project == null || name == null) {
            throw new IllegalArgumentException("Project and name must be non-null.");
        }
        Model model = new Model();
        model.setName(name);
        model.setProject(project);
        model = (Model)this.em.merge((Object)model);
        this.em.flush();
        return model;
    }

    public Model findByProjectAndName(Project project, String name) {
        TypedQuery query = this.em.createNamedQuery("Model.findByProjectAndName", Model.class);
        query.setParameter("name", (Object)name).setParameter("project", (Object)project);
        try {
            return (Model)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Model findByProjectIdAndName(Integer projectId, String name) {
        TypedQuery query = this.em.createNamedQuery("Model.findByProjectIdAndName", Model.class);
        query.setParameter("name", (Object)name).setParameter("projectId", (Object)projectId);
        try {
            return (Model)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public AbstractFacade.CollectionInfo findByProject(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts, Project project) {
        String queryStr = this.buildQuery("SELECT m FROM Model m ", filters, sorts, "m.project = :project ");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT m.name, m.project) FROM Model m ", filters, sorts, "m.project = :project ");
        TypedQuery query = this.em.createQuery(queryStr, Model.class).setParameter("project", (Object)project);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Model.class).setParameter("project", (Object)project);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case DATE_CREATED: {
                Date date = this.getDate(filterBy.getField(), filterBy.getParam());
                q.setParameter(filterBy.getField(), (Object)date);
                break;
            }
            case NAME: 
            case DESCRIPTION: 
            case CREATOR: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
        }
    }

    public static enum Filters {
        DATE_CREATED("DATE_CREATED", "e.created = :created ", "created", ""),
        NAME("NAME", "e.name LIKE CONCAT('%', :name, '%') ", "name", " "),
        DESCRIPTION("NAME", "e.description LIKE CONCAT('%', :description, '%') ", "description", " "),
        CREATOR("CREATOR", "(e.creator.username LIKE CONCAT('%', :creator, '%') OR e.creator.fname LIKE CONCAT('%', :creator, '%') OR e.creator.lname LIKE CONCAT('%', :creator, '%')) ", "creator", " ");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", "e.id ", "ASC"),
        NAME("NAME", "e.name ", "ASC"),
        DATE_CREATED("DATE_CREATED", "e.created ", "DESC"),
        CREATOR("CREATOR", "LOWER(CONCAT (e.creator.fname, e.creator.lname)) ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String toString() {
            return this.value;
        }
    }
}

