/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.models.version;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.QueryParam;
import io.hops.hopsworks.persistence.entity.models.version.ModelVersion;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.util.AbstractFacade;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class ModelVersionFacade
extends AbstractFacade<ModelVersion> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public ModelVersionFacade() {
        super(ModelVersion.class);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public AbstractFacade.CollectionInfo findByProject(Project project, QueryParam queryParam) {
        return new AbstractFacade.CollectionInfo(this.countByProject(project, queryParam), this.getByProject(project, queryParam));
    }

    private List<ModelVersion> getByProject(Project project, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT * FROM hopsworks.`model_version` mv JOIN `hopsworks`.model m ON mv.model_id=m.id ", queryParam != null ? queryParam.getFilters() : null, queryParam != null ? queryParam.getSorts() : null, "m.project_id = ?project_id ");
        Query query = this.em.createNativeQuery(queryStr, ModelVersion.class).setParameter("project_id", (Object)project.getId());
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), query);
            this.setOffsetAndLim(queryParam.getOffset(), queryParam.getLimit(), query);
        }
        return query.getResultList();
    }

    private Long countByProject(Project project, QueryParam queryParam) {
        String queryStr = this.buildQuery("SELECT COUNT(mv.id) FROM hopsworks.`model_version` mv JOIN `hopsworks`.model m ON mv.model_id=m.id ", queryParam != null ? queryParam.getFilters() : null, null, "m.project_id = ?project_id ");
        Query query = this.em.createNativeQuery(queryStr).setParameter("project_id", (Object)project.getId());
        if (queryParam != null) {
            this.setFilter(queryParam.getFilters(), query);
        }
        return (Long)query.getSingleResult();
    }

    public ModelVersion findByProjectAndMlId(Integer modelId, Integer version) {
        TypedQuery query = this.em.createNamedQuery("ModelVersion.findByProjectAndMlId", ModelVersion.class);
        query.setParameter("modelId", (Object)modelId).setParameter("version", (Object)version);
        try {
            return (ModelVersion)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case NAME_EQ: 
            case NAME_LIKE: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case VERSION: {
                q.setParameter(filterBy.getField(), (Object)Integer.valueOf(filterBy.getParam()));
                break;
            }
        }
    }

    public ModelVersion put(ModelVersion modelVersion) {
        modelVersion = (ModelVersion)this.em.merge((Object)modelVersion);
        this.em.flush();
        return modelVersion;
    }

    public static enum Filters {
        NAME_EQ("NAME_EQ", "m.name = ?name", "name", ""),
        NAME_LIKE("NAME_LIKE", "m.name LIKE CONCAT('%', ?name, '%') ", "name", " "),
        VERSION("VERSION", "mv.version = ?version ", "version", ""),
        LATEST_VERSION("LATEST_VERSION", String.format("%1$s.version = ( SELECT MAX(%2$s.version) FROM `hopsworks`.model_version %2$s WHERE %1$s.model_id = %2$s.model_id ) ", "mv", "mv2"), null, null);

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        NAME("NAME", "m.name ", "ASC"),
        METRIC("METRIC", "JSON_VALUE(mv.metrics, '$.attributes.METRIC') IS NULL, CAST(JSON_VALUE(mv.metrics, '$.attributes.METRIC') AS FLOAT) ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;
        private String jsonSortKey;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getSql() {
            if (this.value.equals(Sorts.METRIC.value)) {
                return this.sql.replace("METRIC", this.getJsonSortKey());
            }
            return this.sql;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }

        public String getJsonSortKey() {
            return this.jsonSortKey;
        }

        public void setJsonSortKey(String jsonSortKey) {
            this.jsonSortKey = jsonSortKey;
        }
    }
}

