/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.opensearch.OpenSearchJWTController;
import io.hops.hopsworks.common.proxies.client.HttpRetryableAction;
import io.hops.hopsworks.common.proxies.client.NotFoundClientProtocolException;
import io.hops.hopsworks.common.proxies.client.NotRetryableClientProtocolException;
import io.hops.hopsworks.common.security.BaseHadoopClientsService;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"Settings"})
public class KibanaClient {
    @EJB
    private Settings settings;
    @EJB
    private BaseHadoopClientsService clientsService;
    @EJB
    private OpenSearchJWTController openSearchJWTController;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    private PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient client;
    private ExponentialBackOff.Builder backOffPolicy;

    @PostConstruct
    public void init() throws RuntimeException {
        try {
            this.connectionManager = this.createConnectionManager();
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
        this.backOffPolicy = new ExponentialBackOff.Builder().setMaximumRetries(3).setInitialIntervalMillis(500L).setMaximumIntervalMillis(3000L).setMultiplier(1.5);
    }

    @PreDestroy
    public void destroy() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    private Registry<ConnectionSocketFactory> createConnectionFactory() throws IOException, GeneralSecurityException {
        SSLContext sslCtx = null;
        boolean isSecurityEnabled = this.settings.isOpenSearchSecurityEnabled();
        if (isSecurityEnabled) {
            Path trustStore = Paths.get(this.clientsService.getSuperTrustStorePath(), new String[0]);
            char[] trustStorePassword = this.clientsService.getSuperTrustStorePassword().toCharArray();
            sslCtx = SSLContexts.custom().loadTrustMaterial(trustStore.toFile(), trustStorePassword).build();
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslCtx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager() throws IOException, GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(this.createConnectionFactory());
        connectionManager.setMaxTotal(30);
        connectionManager.setDefaultMaxPerRoute(30);
        return connectionManager;
    }

    public JSONObject createIndexPattern(Users user, Project project, KibanaType type, String id) throws OpenSearchException {
        return this.post(user, project, type, id, "{\"attributes\": {\"title\": \"" + id + "\"}}");
    }

    public JSONObject get(Users user, Project project, KibanaType type, String id) throws OpenSearchException {
        return this.execute(HttpMethod.GET, type, id, null, user, project);
    }

    public JSONObject delete(Users user, Project project, KibanaType type, String id) throws OpenSearchException {
        return this.execute(HttpMethod.DELETE, type, id, null, user, project);
    }

    public JSONObject deleteAsDataOwner(Project project, KibanaType type, String id) throws OpenSearchException {
        return this.execute(HttpMethod.DELETE, type, id, null, null, project, false, true);
    }

    public JSONObject post(Users user, Project project, KibanaType type, String id, String data) throws OpenSearchException {
        return this.execute(HttpMethod.POST, type, id, data, user, project);
    }

    public JSONObject postWithOverwrite(Users user, Project project, KibanaType type, String id, String data) throws OpenSearchException {
        return this.execute(HttpMethod.POST, type, id, data, user, project, true, false);
    }

    private JSONObject execute(HttpMethod method, KibanaType type, String id, String data, Users user, Project project) throws OpenSearchException {
        return this.execute(method, type, id, data, user, project, false, false);
    }

    private HttpUriRequest buildHttpRequest(HttpMethod method, String url, String data) throws OpenSearchException {
        HttpGet httpRequest = null;
        switch (method) {
            case GET: {
                httpRequest = new HttpGet(url);
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete(url);
                break;
            }
            case POST: {
                httpRequest = new HttpPost(url);
                if (data == null) break;
                try {
                    ((HttpPost)httpRequest).setEntity((HttpEntity)new StringEntity(data));
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.KIBANA_REQ_ERROR, Level.INFO, "Failed to execute a Kibana request on " + url, e.getMessage(), (Throwable)e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported method " + (Object)((Object)method));
            }
        }
        return httpRequest;
    }

    private JSONObject execute(HttpMethod method, KibanaType type, String id, String data, Users user, Project project, boolean overwrite, boolean runAsDataOwner) throws OpenSearchException {
        String url = null;
        try {
            url = (this.settings.isKibanaHTTPSEnabled() != false ? "https://" : "http://") + this.serviceDiscoveryController.constructServiceFQDNWithPort(HopsworksService.KIBANA.getName()) + "/api/saved_objects";
        }
        catch (ServiceDiscoveryException e) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.KIBANA_REQ_ERROR, Level.SEVERE, "Failed to execute a Kibana request. Reason: " + e.getMessage(), e.getMessage(), (Throwable)e);
        }
        if (type != KibanaType.All) {
            url = url + "/" + type.toString();
        }
        if (id != null) {
            url = url + "/" + id;
        }
        if (overwrite) {
            url = url + "?overwrite=true";
        }
        try {
            final HttpUriRequest httpRequest = this.buildHttpRequest(method, url, data);
            httpRequest.setHeader("osd-xsrf", "required");
            httpRequest.setHeader("Content-Type", "application/json");
            if (this.settings.isOpenSearchSecurityEnabled()) {
                if (this.settings.isOpenSearchJWTEnabled() && project != null && (user != null || runAsDataOwner)) {
                    String token = runAsDataOwner ? this.openSearchJWTController.createTokenForELKAsDataOwner(project) : this.openSearchJWTController.createTokenForELK(user, project);
                    httpRequest.setHeader("Authorization", "Bearer " + token);
                } else {
                    String userPass = this.settings.getOpenSearchAdminUser() + ":" + this.settings.getOpenSearchAdminPassword();
                    httpRequest.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes()));
                }
            }
            HttpRetryableAction<JSONObject> retryableAction = new HttpRetryableAction<JSONObject>(this.backOffPolicy){

                @Override
                public JSONObject performAction() throws ClientProtocolException, IOException {
                    return (JSONObject)KibanaClient.this.client.execute(httpRequest, httpResponse -> {
                        int statusCode = httpResponse.getStatusLine().getStatusCode();
                        if (statusCode / 100 == 2) {
                            String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                            return Strings.isNullOrEmpty((String)response) ? new JSONObject() : new JSONObject(response);
                        }
                        if (statusCode / 100 == 4) {
                            if (statusCode == 404) {
                                throw new NotFoundClientProtocolException(httpResponse.toString());
                            }
                            throw new NotRetryableClientProtocolException(httpResponse.toString());
                        }
                        throw new ClientProtocolException();
                    });
                }
            };
            return (JSONObject)retryableAction.tryAction();
        }
        catch (IOException e) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.KIBANA_REQ_ERROR, Level.INFO, "Failed to execute a Kibana request. Reason: " + e.getMessage(), "url:" + url, (Throwable)e);
        }
    }

    private static enum HttpMethod {
        GET,
        POST,
        DELETE;

    }

    public static enum KibanaType {
        Visualization("visualization"),
        Search("search"),
        Dashboard("dashboard"),
        IndexPattern("index-pattern"),
        All("saved_objects");

        private String str;

        private KibanaType(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

