/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving;

import io.hops.hopsworks.common.serving.ServingStatusConditionEnum;
import java.io.Serializable;

public class ServingStatusCondition
implements Serializable {
    private ServingStatusConditionEnum type;
    private Boolean status;
    private String reason;
    public static final String ScheduledInProgress = "Waiting for being scheduled";
    public static final String ScheduledFailed = "Failed to be scheduled: ";
    public static final String InitializedInProgress = "Initializing deployment";
    public static final String InitializedFailed = "Failed to initialize: ";
    public static final String StartedInProgress = "Deployment is starting";
    public static final String StartedFailed = "Failed to run: ";
    public static final String ReadyInProgress = "Setting up connectivity";
    public static final String ReadySuccess = "Deployment is ready";
    public static final String ReadyFailed = "Failed to setup connectivity: ";
    public static final String UnscheduledInProgress = "Waiting for being unscheduled";
    public static final String StoppedInProgress = "Stopping deployment";
    public static final String StoppedSuccess = "Deployment is not running";
    public static final String StoppedCreating = "Deployment is being prepared";

    public ServingStatusCondition() {
    }

    public ServingStatusCondition(ServingStatusConditionEnum type, String reason) {
        this.type = type;
        this.status = null;
        this.reason = reason;
    }

    public ServingStatusCondition(ServingStatusConditionEnum type, Boolean status, String reason) {
        this.type = type;
        this.status = status;
        this.reason = reason;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public ServingStatusConditionEnum getType() {
        return this.type;
    }

    public void setType(ServingStatusConditionEnum type) {
        this.type = type;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public static ServingStatusCondition getScheduledInProgressCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.SCHEDULED, ScheduledInProgress);
    }

    public static ServingStatusCondition getScheduledFailedCondition(String errorMsg) {
        return new ServingStatusCondition(ServingStatusConditionEnum.SCHEDULED, false, ScheduledFailed + errorMsg);
    }

    public static ServingStatusCondition getInitializedInProgressCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.INITIALIZED, InitializedInProgress);
    }

    public static ServingStatusCondition getInitializedFailedCondition(String errorMsg) {
        return new ServingStatusCondition(ServingStatusConditionEnum.INITIALIZED, false, InitializedFailed + errorMsg);
    }

    public static ServingStatusCondition getStartedInProgressCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.STARTED, StartedInProgress);
    }

    public static ServingStatusCondition getStartedFailedCondition(String errorMsg) {
        return new ServingStatusCondition(ServingStatusConditionEnum.STARTED, false, StartedFailed + errorMsg);
    }

    public static ServingStatusCondition getReadyInProgressCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.READY, ReadyInProgress);
    }

    public static ServingStatusCondition getReadyFailedCondition(String errorMsg) {
        return new ServingStatusCondition(ServingStatusConditionEnum.READY, false, ReadyFailed + errorMsg);
    }

    public static ServingStatusCondition getReadySuccessCondition() {
        return ServingStatusCondition.getReadySuccessCondition(ReadySuccess);
    }

    public static ServingStatusCondition getReadySuccessCondition(String successMsg) {
        return new ServingStatusCondition(ServingStatusConditionEnum.READY, true, successMsg);
    }

    public static ServingStatusCondition getUnscheduledInProgressCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.SCHEDULED, UnscheduledInProgress);
    }

    public static ServingStatusCondition getStoppedInProgressCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.STOPPED, StoppedInProgress);
    }

    public static ServingStatusCondition getStoppedSuccessCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.STOPPED, true, StoppedSuccess);
    }

    public static ServingStatusCondition getStoppedCreatingCondition() {
        return new ServingStatusCondition(ServingStatusConditionEnum.STOPPED, StoppedCreating);
    }
}

