/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import io.hops.hopsworks.common.upload.FlowInfo;
import io.hops.hopsworks.common.upload.ResumableInfoProcessor;
import io.hops.hopsworks.common.upload.UploadInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ResumableInfoStorage {
    private static final Logger LOGGER = Logger.getLogger(ResumableInfoStorage.class.getName());
    private static final String MAP_NAME = "uploadInfo";
    @Inject
    private HazelcastInstance hazelcastInstance;
    @Resource
    private TimerService timerService;
    @EJB
    private ResumableInfoProcessor resumableInfoProcessor;
    private ConcurrentHashMap<Integer, UploadInfo> flowInfoMap;

    @VisibleForTesting
    public void initialize() {
        this.flowInfoMap = new ConcurrentHashMap();
    }

    @PostConstruct
    protected void init() {
        if (this.hazelcastInstance != null) {
            if (this.hazelcastInstance.getConfig().getMapConfigOrNull(MAP_NAME) == null) {
                MapConfig mapConfig = new MapConfig(MAP_NAME);
                mapConfig.setMaxIdleSeconds(1800);
                this.hazelcastInstance.getConfig().addMapConfig(mapConfig);
            }
        } else {
            this.flowInfoMap = new ConcurrentHashMap();
            this.timerService.createIntervalTimer(0L, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS), new TimerConfig((Serializable)((Object)"Clean expired upload info."), false));
        }
    }

    @Timeout
    public void cleanExpiredUploadInfo() {
        try {
            long now = new Date().getTime();
            this.flowInfoMap.entrySet().removeIf(e -> {
                long diff = now - ((UploadInfo)e.getValue()).getLastWrite().getTime();
                LOGGER.log(Level.INFO, "Removing Expired Upload Info: {0}, last write : {1} minutes ago", new Object[]{e.getValue(), TimeUnit.MILLISECONDS.toMinutes(diff)});
                return TimeUnit.MILLISECONDS.toMinutes(diff) > 30L;
            });
        }
        catch (Exception e2) {
            LOGGER.log(Level.WARNING, "Failed to Clean expired upload info map. Error: {0}", e2.getMessage());
        }
    }

    public void put(FlowInfo flowInfo) {
        if (this.hazelcastInstance != null) {
            this.resumableInfoProcessor.put(flowInfo, this.hazelcastInstance, MAP_NAME);
        } else {
            this.flowInfoMap.putIfAbsent(flowInfo.hashCode(), new UploadInfo(flowInfo.getTotalSize()));
        }
    }

    public boolean addChunkAndCheckIfFinished(FlowInfo info, int rcn, long contentLength) {
        boolean finished;
        if (this.hazelcastInstance != null) {
            finished = this.resumableInfoProcessor.addChunkAndCheckIfFinished(info, rcn, contentLength, this.hazelcastInstance, MAP_NAME);
        } else {
            UploadInfo uploadInfo = this.flowInfoMap.get(info.hashCode());
            if (uploadInfo == null) {
                return false;
            }
            finished = uploadInfo.addChunkAndCheckIfFinished(rcn, contentLength);
            if (finished) {
                this.flowInfoMap.remove(info.hashCode());
            }
        }
        return finished;
    }

    public boolean uploaded(Integer identifier, Integer rcn) {
        if (this.hazelcastInstance != null) {
            return this.resumableInfoProcessor.uploaded(identifier, rcn, this.hazelcastInstance, MAP_NAME);
        }
        UploadInfo uploadInfo = this.flowInfoMap.get(identifier);
        return uploadInfo != null && uploadInfo.getUploadedChunks().contains(rcn);
    }
}

