/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import io.hops.hopsworks.common.util.Settings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class TemplateEngine {
    private static final Logger LOGGER = Logger.getLogger(TemplateEngine.class.getName());
    @EJB
    private Settings settings;
    private Configuration configuration;

    @PostConstruct
    public void init() {
        Path templatesDirectory = Paths.get(this.settings.getHopsworksDomainDir(), "templates");
        this.configuration = new Configuration(Configuration.VERSION_2_3_29);
        try {
            this.configuration.setDirectoryForTemplateLoading(templatesDirectory.toFile());
            this.configuration.setDefaultEncoding("UTF-8");
            this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.configuration.setLogTemplateExceptions(false);
            this.configuration.setWrapUncheckedExceptions(true);
            this.configuration.setFallbackOnNullLoopVariable(false);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to configure Templating engine!", ex);
        }
    }

    @Lock(value=LockType.READ)
    public void template(String templateName, Map<String, Object> dataModel, Writer out) throws IOException, TemplateException {
        this.isInitialized();
        if (dataModel == null) {
            throw new IOException("Data model is null");
        }
        dataModel.putIfAbsent("instanceOf", new InstanceOf());
        Template template = this.configuration.getTemplate(templateName);
        template.process(dataModel, out);
    }

    @Lock(value=LockType.READ)
    public String template(Map<String, Object> dataModel, StringWriter stringWriter, String templateName) throws IOException, TemplateException {
        this.isInitialized();
        if (dataModel == null) {
            throw new IOException("Data model is null");
        }
        dataModel.putIfAbsent("instanceOf", new InstanceOf());
        Template template = this.configuration.getTemplate(templateName);
        template.process(dataModel, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private void isInitialized() throws IOException {
        if (this.configuration == null) {
            throw new IOException("Template engine is not initialized");
        }
    }

    private static class InstanceOf
    implements TemplateMethodModelEx {
        private InstanceOf() {
        }

        public Object exec(List list) throws TemplateModelException {
            if (list.size() != 2) {
                throw new TemplateModelException("Wrong usage. First argument is an object and the second is a class");
            }
            Object obj = ((WrapperTemplateModel)list.get(0)).getWrappedObject();
            Object cls = ((WrapperTemplateModel)list.get(1)).getWrappedObject();
            if (!(cls instanceof Class)) {
                throw new TemplateModelException("Second argument must be a Class");
            }
            return ((Class)cls).isAssignableFrom(obj.getClass());
        }
    }
}

