/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.agent;

import io.hops.hopsworks.common.admin.services.HostServicesController;
import io.hops.hopsworks.common.dao.command.HeartbeatReplyDTO;
import io.hops.hopsworks.common.dao.command.SystemCommandFacade;
import io.hops.hopsworks.common.dao.host.HostsFacade;
import io.hops.hopsworks.common.hosts.HostsController;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.command.CommandStatus;
import io.hops.hopsworks.persistence.entity.command.SystemCommand;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import io.hops.hopsworks.persistence.entity.host.ServiceStatus;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class AgentController {
    private static final Logger LOG = Logger.getLogger(AgentController.class.getName());
    private static final Comparator ASC_COMPARATOR = new CommandsComparator();
    @EJB
    private HostsFacade hostsFacade;
    @EJB
    private SystemCommandFacade systemCommandFacade;
    @EJB
    private HostsController hostsController;
    @EJB
    private HostServicesController hostServicesController;

    public void register(String hostname, String hostIp, String password) throws ServiceException {
        Hosts host = this.hostsFacade.findByHostname(hostname).orElseGet(Hosts::new);
        host.setAgentPassword(password);
        host.setRegistered(Boolean.valueOf(true));
        host.setHostname(hostname);
        host.setHostIp(hostIp);
        this.hostsFacade.update(host);
    }

    public HeartbeatReplyDTO heartbeat(AgentHeartbeatDTO heartbeat) throws ServiceException {
        Hosts host = this.hostsController.findByHostname(heartbeat.hostId);
        if (!host.getRegistered().booleanValue()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.HOST_NOT_REGISTERED, Level.WARNING, "hostId: " + heartbeat.hostId);
        }
        this.updateHostMetrics(host, heartbeat);
        this.updateServices(heartbeat);
        this.processSystemCommands(heartbeat);
        if (heartbeat.recover != null && heartbeat.recover.booleanValue()) {
            this.recoverUnfinishedCommands(host);
        }
        HeartbeatReplyDTO response = new HeartbeatReplyDTO();
        this.addNewCommandsToResponse(host, response);
        return response;
    }

    private void recoverUnfinishedCommands(Hosts host) {
        this.recoverSystemCommands(host);
    }

    private void recoverSystemCommands(Hosts host) {
        List<SystemCommand> allUnfinished = this.systemCommandFacade.findUnfinishedByHost(host);
        for (SystemCommand command : allUnfinished) {
            command.setCommandStatus(CommandStatus.NEW);
            this.systemCommandFacade.update(command);
        }
    }

    private void addNewCommandsToResponse(Hosts host, HeartbeatReplyDTO response) {
        ArrayList<SystemCommand> newSystemCommands = new ArrayList<SystemCommand>();
        List<SystemCommand> allSystemCommands = this.systemCommandFacade.findByHost(host);
        for (SystemCommand sc : allSystemCommands) {
            if (!sc.getCommandStatus().equals((Object)CommandStatus.NEW)) continue;
            newSystemCommands.add(sc);
        }
        newSystemCommands.sort(ASC_COMPARATOR);
        response.setSystemCommands(newSystemCommands);
    }

    private void updateHostMetrics(Hosts host, AgentHeartbeatDTO heartbeat) {
        host.setLastHeartbeat(Long.valueOf(new Date().getTime()));
        host.setNumGpus(heartbeat.numGpus);
        host.setPrivateIp(heartbeat.privateIp);
        host.setCores(heartbeat.cores);
        host.setMemoryCapacity(heartbeat.memoryCapacity);
        this.hostsFacade.update(host);
    }

    private void updateServices(AgentHeartbeatDTO heartbeat) throws ServiceException {
        this.hostServicesController.updateHostServices(heartbeat);
    }

    private void processSystemCommands(AgentHeartbeatDTO heartbeat) {
        if (heartbeat.systemCommands == null) {
            return;
        }
        for (SystemCommand sc : heartbeat.systemCommands) {
            Integer id = sc.getId();
            CommandStatus status = sc.getCommandStatus();
            SystemCommand systemCommand = this.systemCommandFacade.findById(id);
            if (systemCommand == null) {
                throw new IllegalArgumentException("System command with ID: " + id + " is not in the system");
            }
            this.genericProcessSystemCommand(systemCommand, status);
        }
    }

    private void genericProcessSystemCommand(SystemCommand command, CommandStatus commandStatus) {
        if (commandStatus.equals((Object)CommandStatus.FINISHED)) {
            this.systemCommandFacade.delete(command);
        } else {
            command.setCommandStatus(commandStatus);
            this.systemCommandFacade.update(command);
        }
    }

    private static class CommandsComparator<T>
    implements Comparator<T>,
    Serializable {
        private CommandsComparator() {
        }

        @Override
        public int compare(T t, T t1) {
            if (t instanceof SystemCommand && t1 instanceof SystemCommand) {
                return this.systemCommandCompare((SystemCommand)t, (SystemCommand)t1);
            }
            return 0;
        }

        private int systemCommandCompare(SystemCommand t, SystemCommand t1) {
            if (t.getId() > t1.getId()) {
                return 1;
            }
            if (t.getId() < t1.getId()) {
                return -1;
            }
            return 0;
        }
    }

    public static class AgentServiceDTO {
        private final String name;
        private final String group;
        private final Integer pid;
        private final ServiceStatus status;

        public AgentServiceDTO(String name, String group, Integer pid, ServiceStatus status) {
            this.name = name;
            this.group = group;
            this.pid = pid;
            this.status = status;
        }

        public String getName() {
            return this.name;
        }

        public String getGroup() {
            return this.group;
        }

        public Integer getPid() {
            return this.pid;
        }

        public ServiceStatus getStatus() {
            return this.status;
        }
    }

    public static class AgentHeartbeatDTO {
        private final String hostId;
        private final Long agentTime;
        private final Integer numGpus;
        private final Long memoryCapacity;
        private final Integer cores;
        private final String privateIp;
        private final List<AgentServiceDTO> services;
        private final List<SystemCommand> systemCommands;
        private final Boolean recover;

        public AgentHeartbeatDTO(String hostId, Long agentTime, Integer numGpus, Long memoryCapacity, Integer cores, String privateIp, List<AgentServiceDTO> services, List<SystemCommand> systemCommands, Boolean recover) {
            this.hostId = hostId;
            this.agentTime = agentTime;
            this.numGpus = numGpus;
            this.memoryCapacity = memoryCapacity;
            this.cores = cores;
            this.privateIp = privateIp;
            this.services = services;
            this.systemCommands = systemCommands;
            this.recover = recover;
        }

        public String getHostId() {
            return this.hostId;
        }

        public Long getAgentTime() {
            return this.agentTime;
        }

        public Integer getNumGpus() {
            return this.numGpus;
        }

        public Long getMemoryCapacity() {
            return this.memoryCapacity;
        }

        public Integer getCores() {
            return this.cores;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public List<AgentServiceDTO> getServices() {
            return this.services;
        }

        public List<SystemCommand> getSystemCommands() {
            return this.systemCommands;
        }

        public Boolean getRecover() {
            return this.recover;
        }
    }
}

